package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentDateRule;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentDateRule.OtherPaymentDateRuleDefault.class)
public abstract class OtherPaymentDateRule implements ReportFunction<TransferState, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentDateRule cDEOtherPaymentDateRule;
	@Inject protected IsOtherPayment isOtherPayment;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(TransferState input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(TransferState input);

	public static class OtherPaymentDateRuleDefault extends OtherPaymentDateRule {
		@Override
		protected Date doEvaluate(TransferState input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, TransferState input) {
			final MapperS<TransferState> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isOtherPayment.evaluate(item.get()));
			output = MapperS.of(cDEOtherPaymentDateRule.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
