package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.OtherPaymentReport;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg1;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg2;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("JFSATransactionReportDTCC_JFSA_BR_0034_02")
@ImplementedBy(JFSATransactionReportDTCC_JFSA_BR_0034_02.Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0034_02 extends Validator<JFSATransactionReport> {
	
	String NAME = "JFSATransactionReportDTCC_JFSA_BR_0034_02";
	String DEFINITION = "if actionType = ActionTypeEnum -> NEWT to-string and assetClass = \"CRDT\" then (if fixedRateLeg1 is absent and fixedRateLeg2 is absent and spreadOfLeg1 is absent and spreadOfLeg2 is absent then otherPayment -> paymentType all = \"UFRO\")";
	
	class Default implements JFSATransactionReportDTCC_JFSA_BR_0034_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			ComparisonResult result = executeDataRule(jFSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
			try {
				if (areEqual(MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).and(areEqual(MapperS.of(jFSATransactionReport).<String>map("getAssetClass", _jFSATransactionReport -> _jFSATransactionReport.getAssetClass()), MapperS.of("CRDT"), CardinalityOperator.All)).getOrDefault(false)) {
					if (notExists(MapperS.of(jFSATransactionReport).<BigDecimal>map("getFixedRateLeg1", _jFSATransactionReport -> _jFSATransactionReport.getFixedRateLeg1())).and(notExists(MapperS.of(jFSATransactionReport).<BigDecimal>map("getFixedRateLeg2", _jFSATransactionReport -> _jFSATransactionReport.getFixedRateLeg2()))).and(notExists(MapperS.of(jFSATransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _jFSATransactionReport -> _jFSATransactionReport.getSpreadOfLeg1()))).and(notExists(MapperS.of(jFSATransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _jFSATransactionReport -> _jFSATransactionReport.getSpreadOfLeg2()))).getOrDefault(false)) {
						return areEqual(MapperS.of(jFSATransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _jFSATransactionReport -> _jFSATransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.All);
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSATransactionReportDTCC_JFSA_BR_0034_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
