package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("JFSATransactionReportDTCC_JFSA_BR_0115_01")
@ImplementedBy(JFSATransactionReportDTCC_JFSA_BR_0115_01.Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0115_01 extends Validator<JFSATransactionReport> {
	
	String NAME = "JFSATransactionReportDTCC_JFSA_BR_0115_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and assetClass = \"INTR\" then (if fixedRateLeg1 is absent and nameOfTheFloatingRateOfLeg1 is absent and underlyingIdentificationType is absent then indicatorOfTheFloatingRateOfLeg1 exists)";
	
	class Default implements JFSATransactionReportDTCC_JFSA_BR_0115_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			ComparisonResult result = executeDataRule(jFSATransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of(jFSATransactionReport).<String>map("getAssetClass", _jFSATransactionReport -> _jFSATransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All)).getOrDefault(false)) {
					if (notExists(MapperS.of(jFSATransactionReport).<BigDecimal>map("getFixedRateLeg1", _jFSATransactionReport -> _jFSATransactionReport.getFixedRateLeg1())).and(notExists(MapperS.of(jFSATransactionReport).<String>map("getNameOfTheFloatingRateOfLeg1", _jFSATransactionReport -> _jFSATransactionReport.getNameOfTheFloatingRateOfLeg1()))).and(notExists(MapperS.of(jFSATransactionReport).<String>map("getUnderlyingIdentificationType", _jFSATransactionReport -> _jFSATransactionReport.getUnderlyingIdentificationType()))).getOrDefault(false)) {
						return exists(MapperS.of(jFSATransactionReport).<String>map("getIndicatorOfTheFloatingRateOfLeg1", _jFSATransactionReport -> _jFSATransactionReport.getIndicatorOfTheFloatingRateOfLeg1()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSATransactionReportDTCC_JFSA_BR_0115_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
