package drr.regulation.jfsa.rewrite.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.jfsa.rewrite.trade.BarrierAndNotation;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class BarrierAndNotationOnlyExistsValidator implements ValidatorWithArg<BarrierAndNotation, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends BarrierAndNotation> ValidationResult<BarrierAndNotation> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("singleBarrierPriceMonetary", ExistenceChecker.isSet((BigDecimal) o.getSingleBarrierPriceMonetary()))
				.put("singleBarrierPriceDecimal", ExistenceChecker.isSet((BigDecimal) o.getSingleBarrierPriceDecimal()))
				.put("lowerBarrierPriceMonetary", ExistenceChecker.isSet((BigDecimal) o.getLowerBarrierPriceMonetary()))
				.put("lowerBarrierPriceDecimal", ExistenceChecker.isSet((BigDecimal) o.getLowerBarrierPriceDecimal()))
				.put("upperBarrierPriceMonetary", ExistenceChecker.isSet((BigDecimal) o.getUpperBarrierPriceMonetary()))
				.put("upperBarrierPriceDecimal", ExistenceChecker.isSet((BigDecimal) o.getUpperBarrierPriceDecimal()))
				.put("singleBarrierPriceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getSingleBarrierPriceNotation()))
				.put("lowerBarrierPriceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getLowerBarrierPriceNotation()))
				.put("upperBarrierPriceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getUpperBarrierPriceNotation()))
				.put("singleBarrierPriceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSingleBarrierPriceCurrency()))
				.put("lowerBarrierPriceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getLowerBarrierPriceCurrency()))
				.put("upperBarrierPriceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getUpperBarrierPriceCurrency()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("BarrierAndNotation", ValidationResult.ValidationType.ONLY_EXISTS, "BarrierAndNotation", path, "");
		}
		return failure("BarrierAndNotation", ValidationResult.ValidationType.ONLY_EXISTS, "BarrierAndNotation", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
