package drr.regulation.jfsa.rewrite.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.jfsa.rewrite.trade.BarrierAndNotation;
import drr.regulation.jfsa.rewrite.trade.BasketConstituentsReport;
import drr.regulation.jfsa.rewrite.trade.JFSANonReportable;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.jfsa.rewrite.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.jfsa.rewrite.trade.NotionalQuantityScheduleLeg2Report;
import drr.regulation.jfsa.rewrite.trade.OtherPaymentReport;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionPrice;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionSpread;
import drr.regulation.jfsa.rewrite.trade.PriceAndNotation;
import drr.regulation.jfsa.rewrite.trade.PriceScheduleReport;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg1;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg2;
import drr.regulation.jfsa.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.jfsa.rewrite.trade.StrikePriceScheduleReport;
import iso20022.auth030.jfsa.InterestComputationMethod4Code;
import iso20022.auth030.jfsa.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class JFSATransactionReportOnlyExistsValidator implements ValidatorWithArg<JFSATransactionReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends JFSATransactionReport> ValidationResult<JFSATransactionReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.put("expirationDate", ExistenceChecker.isSet((Date) o.getExpirationDate()))
				.put("earlyTerminationDate", ExistenceChecker.isSet((Date) o.getEarlyTerminationDate()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("executionTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getExecutionTimestamp()))
				.put("entityResponsibleForReporting", ExistenceChecker.isSet((String) o.getEntityResponsibleForReporting()))
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2IdentifierType", ExistenceChecker.isSet((Boolean) o.getCounterparty2IdentifierType()))
				.put("direction1", ExistenceChecker.isSet((String) o.getDirection1()))
				.put("direction2Leg1", ExistenceChecker.isSet((String) o.getDirection2Leg1()))
				.put("direction2Leg2", ExistenceChecker.isSet((String) o.getDirection2Leg2()))
				.put("submitterIdentifier", ExistenceChecker.isSet((String) o.getSubmitterIdentifier()))
				.put("newSDRIdentifier", ExistenceChecker.isSet((String) o.getNewSDRIdentifier()))
				.put("originalSwapSDRIdentifier", ExistenceChecker.isSet((String) o.getOriginalSwapSDRIdentifier()))
				.put("cleared", ExistenceChecker.isSet((String) o.getCleared()))
				.put("centralCounterparty", ExistenceChecker.isSet((String) o.getCentralCounterparty()))
				.put("clearingMember", ExistenceChecker.isSet((String) o.getClearingMember()))
				.put("platformIdentifier", ExistenceChecker.isSet((String) o.getPlatformIdentifier()))
				.put("confirmed", ExistenceChecker.isSet((String) o.getConfirmed()))
				.put("finalContractualSettlementDate", ExistenceChecker.isSet((Date) o.getFinalContractualSettlementDate()))
				.put("confirmationTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getConfirmationTimestamp()))
				.put("settlementCurrencyLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg1()))
				.put("settlementCurrencyLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg2()))
				.put("clearingAccountOrigin", ExistenceChecker.isSet((String) o.getClearingAccountOrigin()))
				.put("originalSwapUTI", ExistenceChecker.isSet((String) o.getOriginalSwapUTI()))
				.put("originalSwapUTIProprietary", ExistenceChecker.isSet((String) o.getOriginalSwapUTIProprietary()))
				.put("clearingReceiptTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getClearingReceiptTimestamp()))
				.put("uti", ExistenceChecker.isSet((String) o.getUti()))
				.put("utiProprietary", ExistenceChecker.isSet((String) o.getUtiProprietary()))
				.put("priorUti", ExistenceChecker.isSet((String) o.getPriorUti()))
				.put("priorUtiProprietary", ExistenceChecker.isSet((String) o.getPriorUtiProprietary()))
				.put("fixedRateDayCountConventionLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg1()))
				.put("floatingRateDayCountConventionOfLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg1()))
				.put("fixedRateDayCountConventionLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg2()))
				.put("floatingRateDayCountConventionOfLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg2()))
				.put("fixedRatePaymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getFixedRatePaymentFrequencyPeriodLeg1()))
				.put("fixedRatePaymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getFixedRatePaymentFrequencyPeriodLeg2()))
				.put("floatingRatePaymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getFloatingRatePaymentFrequencyPeriodLeg1()))
				.put("floatingRatePaymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getFloatingRatePaymentFrequencyPeriodLeg2()))
				.put("fixedRatePaymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1()))
				.put("fixedRatePaymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2()))
				.put("floatingRatePaymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()))
				.put("floatingRatePaymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()))
				.put("fixingDateLeg1", ExistenceChecker.isSet((ZonedDateTime) o.getFixingDateLeg1()))
				.put("fixingDateLeg2", ExistenceChecker.isSet((ZonedDateTime) o.getFixingDateLeg2()))
				.put("floatingRateResetFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getFloatingRateResetFrequencyPeriodLeg1()))
				.put("floatingRateResetFrequencyPeriodOfLeg2", ExistenceChecker.isSet((String) o.getFloatingRateResetFrequencyPeriodOfLeg2()))
				.put("floatingRateResetFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg1()))
				.put("floatingRateResetFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg2()))
				.put("otherPayment", ExistenceChecker.isSet((List<? extends OtherPaymentReport>) o.getOtherPayment()))
				.put("valuationAmount", ExistenceChecker.isSet((BigDecimal) o.getValuationAmount()))
				.put("valuationCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getValuationCurrency()))
				.put("valuationMethod", ExistenceChecker.isSet((ValuationType1Code) o.getValuationMethod()))
				.put("valuationTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getValuationTimestamp()))
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("price", ExistenceChecker.isSet((PriceAndNotation) o.getPrice()))
				.put("priceNotation", ExistenceChecker.isSet((String) o.getPriceNotation()))
				.put("priceUnitOfMeasure", ExistenceChecker.isSet((String) o.getPriceUnitOfMeasure()))
				.put("priceSchedule", ExistenceChecker.isSet((List<? extends PriceScheduleReport>) o.getPriceSchedule()))
				.put("fixedRateLeg1", ExistenceChecker.isSet((BigDecimal) o.getFixedRateLeg1()))
				.put("fixedRateLeg2", ExistenceChecker.isSet((BigDecimal) o.getFixedRateLeg2()))
				.put("spreadOfLeg1", ExistenceChecker.isSet((SpreadOfLeg1) o.getSpreadOfLeg1()))
				.put("spreadNotationOfLeg1", ExistenceChecker.isSet((String) o.getSpreadNotationOfLeg1()))
				.put("spreadOfLeg2", ExistenceChecker.isSet((SpreadOfLeg2) o.getSpreadOfLeg2()))
				.put("spreadNotationOfLeg2", ExistenceChecker.isSet((String) o.getSpreadNotationOfLeg2()))
				.put("strikePrice", ExistenceChecker.isSet((StrikePriceAndNotation) o.getStrikePrice()))
				.put("strikePriceNotation", ExistenceChecker.isSet((String) o.getStrikePriceNotation()))
				.put("strikePriceSchedule", ExistenceChecker.isSet((List<? extends StrikePriceScheduleReport>) o.getStrikePriceSchedule()))
				.put("optionPremiumAmount", ExistenceChecker.isSet((BigDecimal) o.getOptionPremiumAmount()))
				.put("optionPremiumCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getOptionPremiumCurrency()))
				.put("optionPremiumPaymentDate", ExistenceChecker.isSet((Date) o.getOptionPremiumPaymentDate()))
				.put("firstExerciseDate", ExistenceChecker.isSet((Date) o.getFirstExerciseDate()))
				.put("exchangeRate", ExistenceChecker.isSet((BigDecimal) o.getExchangeRate()))
				.put("exchangeRateBasis", ExistenceChecker.isSet((String) o.getExchangeRateBasis()))
				.put("notionalLeg1", ExistenceChecker.isSet((BigDecimal) o.getNotionalLeg1()))
				.put("notionalLeg2", ExistenceChecker.isSet((BigDecimal) o.getNotionalLeg2()))
				.put("callAmount", ExistenceChecker.isSet((BigDecimal) o.getCallAmount()))
				.put("putAmount", ExistenceChecker.isSet((BigDecimal) o.getPutAmount()))
				.put("notionalCurrencyOfLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrencyOfLeg1()))
				.put("notionalCurrencyOfLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrencyOfLeg2()))
				.put("callCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCallCurrency()))
				.put("putCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPutCurrency()))
				.put("quantityUnitOfMeasureLeg1", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg1()))
				.put("quantityUnitOfMeasureLeg2", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg2()))
				.put("notionalAmountScheduleLeg1", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg1Report>) o.getNotionalAmountScheduleLeg1()))
				.put("notionalAmountScheduleLeg2", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg2Report>) o.getNotionalAmountScheduleLeg2()))
				.put("totalNotionalQuantityLeg1", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg1()))
				.put("totalNotionalQuantityLeg2", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg2()))
				.put("notionalQuantityScheduleLeg1", ExistenceChecker.isSet((List<? extends NotionalQuantityScheduleLeg1Report>) o.getNotionalQuantityScheduleLeg1()))
				.put("notionalQuantityScheduleLeg2", ExistenceChecker.isSet((List<? extends NotionalQuantityScheduleLeg2Report>) o.getNotionalQuantityScheduleLeg2()))
				.put("actionType", ExistenceChecker.isSet((String) o.getActionType()))
				.put("eventType", ExistenceChecker.isSet((String) o.getEventType()))
				.put("eventTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getEventTimestamp()))
				.put("eventIdentifier", ExistenceChecker.isSet((String) o.getEventIdentifier()))
				.put("indexFactor", ExistenceChecker.isSet((BigDecimal) o.getIndexFactor()))
				.put("embeddedOptionType", ExistenceChecker.isSet((String) o.getEmbeddedOptionType()))
				.put("upi", ExistenceChecker.isSet((String) o.getUpi()))
				.put("deliveryType", ExistenceChecker.isSet((String) o.getDeliveryType()))
				.put("assetClass", ExistenceChecker.isSet((String) o.getAssetClass()))
				.put("underlyingIdentificationType", ExistenceChecker.isSet((String) o.getUnderlyingIdentificationType()))
				.put("underlyingIdentification", ExistenceChecker.isSet((String) o.getUnderlyingIdentification()))
				.put("underlyingIndexIndicator", ExistenceChecker.isSet((String) o.getUnderlyingIndexIndicator()))
				.put("nameOfTheUnderlyingIndex", ExistenceChecker.isSet((String) o.getNameOfTheUnderlyingIndex()))
				.put("referenceEntity", ExistenceChecker.isSet((String) o.getReferenceEntity()))
				.put("indicatorOfTheFloatingRateOfLeg1", ExistenceChecker.isSet((String) o.getIndicatorOfTheFloatingRateOfLeg1()))
				.put("indicatorOfTheFloatingRateOfLeg2", ExistenceChecker.isSet((String) o.getIndicatorOfTheFloatingRateOfLeg2()))
				.put("nameOfTheFloatingRateOfLeg1", ExistenceChecker.isSet((String) o.getNameOfTheFloatingRateOfLeg1()))
				.put("nameOfTheFloatingRateOfLeg2", ExistenceChecker.isSet((String) o.getNameOfTheFloatingRateOfLeg2()))
				.put("floatingRateReferencePeriodOfLeg1TimePeriod", ExistenceChecker.isSet((String) o.getFloatingRateReferencePeriodOfLeg1TimePeriod()))
				.put("floatingRateReferencePeriodOfLeg2TimePeriod", ExistenceChecker.isSet((String) o.getFloatingRateReferencePeriodOfLeg2TimePeriod()))
				.put("floatingRateReferencePeriodOfLeg1Multiplier", ExistenceChecker.isSet((Integer) o.getFloatingRateReferencePeriodOfLeg1Multiplier()))
				.put("floatingRateReferencePeriodOfLeg2Multiplier", ExistenceChecker.isSet((Integer) o.getFloatingRateReferencePeriodOfLeg2Multiplier()))
				.put("isCrypto", ExistenceChecker.isSet((Boolean) o.getIsCrypto()))
				.put("maturityDateOfTheUnderlying", ExistenceChecker.isSet((Date) o.getMaturityDateOfTheUnderlying()))
				.put("seniority", ExistenceChecker.isSet((String) o.getSeniority()))
				.put("series", ExistenceChecker.isSet((Integer) o.getSeries()))
				.put("version", ExistenceChecker.isSet((Integer) o.getVersion()))
				.put("cdSIndexAttachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCdSIndexAttachmentPoint()))
				.put("cdSIndexDetachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCdSIndexDetachmentPoint()))
				.put("customBasketCode", ExistenceChecker.isSet((String) o.getCustomBasketCode()))
				.put("basketConstituents", ExistenceChecker.isSet((List<? extends BasketConstituentsReport>) o.getBasketConstituents()))
				.put("contractType", ExistenceChecker.isSet((String) o.getContractType()))
				.put("optionStyle", ExistenceChecker.isSet((String) o.getOptionStyle()))
				.put("optionType", ExistenceChecker.isSet((String) o.getOptionType()))
				.put("packageIdentifier", ExistenceChecker.isSet((String) o.getPackageIdentifier()))
				.put("packageTransactionPrice", ExistenceChecker.isSet((PackageTransactionPrice) o.getPackageTransactionPrice()))
				.put("packageTransactionPriceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPackageTransactionPriceCurrency()))
				.put("packageTransactionPriceNotation", ExistenceChecker.isSet((String) o.getPackageTransactionPriceNotation()))
				.put("packageTransactionSpread", ExistenceChecker.isSet((PackageTransactionSpread) o.getPackageTransactionSpread()))
				.put("packageTransactionSpreadCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPackageTransactionSpreadCurrency()))
				.put("packageTransactionSpreadNotation", ExistenceChecker.isSet((String) o.getPackageTransactionSpreadNotation()))
				.put("delta", ExistenceChecker.isSet((BigDecimal) o.getDelta()))
				.put("technicalRecordId", ExistenceChecker.isSet((String) o.getTechnicalRecordId()))
				.put("barrier", ExistenceChecker.isSet((BarrierAndNotation) o.getBarrier()))
				.put("nonReportable", ExistenceChecker.isSet((JFSANonReportable) o.getNonReportable()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("JFSATransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "JFSATransactionReport", path, "");
		}
		return failure("JFSATransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "JFSATransactionReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
