package drr.regulation.mas.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralDetails;
import drr.regulation.common.CollateralReportInstruction;
import iso20022.auth108.esma.CollateralisationType3Code__1;
import iso20022.auth108.mas.CollateralisationType3Code;


@ImplementedBy(CollateralisationCategoryRule.CollateralisationCategoryRuleDefault.class)
public abstract class CollateralisationCategoryRule implements ReportFunction<CollateralReportInstruction, CollateralisationType3Code> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CollateralisationType3Code evaluate(CollateralReportInstruction input) {
		CollateralisationType3Code output = doEvaluate(input);
		
		return output;
	}

	protected abstract CollateralisationType3Code doEvaluate(CollateralReportInstruction input);

	public static class CollateralisationCategoryRuleDefault extends CollateralisationCategoryRule {
		@Override
		protected CollateralisationType3Code doEvaluate(CollateralReportInstruction input) {
			CollateralisationType3Code output = null;
			return assignOutput(output, input);
		}
		
		protected CollateralisationType3Code assignOutput(CollateralisationType3Code output, CollateralReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<CollateralDetails>map("getCollateralDetails", collateralReportInstruction -> collateralReportInstruction.getCollateralDetails()).<CollateralisationType3Code__1>map("getCollateralisationCategory", collateralDetails -> collateralDetails.getCollateralisationCategory()).checkedMap("to-enum", e -> CollateralisationType3Code.valueOf(e.name()), IllegalArgumentException.class)).get();
			
			return output;
		}
	}
}
