package drr.regulation.mas.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.standards.iosco.cde.reports.CDECurrencyOfExcessCollateralPostedRule;
import javax.inject.Inject;


@ImplementedBy(CurrencyOfExcessCollateralPostedRule.CurrencyOfExcessCollateralPostedRuleDefault.class)
public abstract class CurrencyOfExcessCollateralPostedRule implements ReportFunction<CollateralReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDECurrencyOfExcessCollateralPostedRule cDECurrencyOfExcessCollateralPostedRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(CollateralReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(CollateralReportInstruction input);

	public static class CurrencyOfExcessCollateralPostedRuleDefault extends CurrencyOfExcessCollateralPostedRule {
		@Override
		protected String doEvaluate(CollateralReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, CollateralReportInstruction input) {
			output = cDECurrencyOfExcessCollateralPostedRule.evaluate(input);
			
			return output;
		}
	}
}
