package drr.regulation.mas.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.mas.rewrite.trade.meta.SpreadOfLeg2Meta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="SpreadOfLeg2", builder=SpreadOfLeg2.SpreadOfLeg2BuilderImpl.class, version="5.53.0")
@RuneDataType(value="SpreadOfLeg2", model="drr", builder=SpreadOfLeg2.SpreadOfLeg2BuilderImpl.class, version="5.53.0")
public interface SpreadOfLeg2 extends RosettaModelObject {

	SpreadOfLeg2Meta metaData = new SpreadOfLeg2Meta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getSpreadOfLeg2Monetary();
	BigDecimal getSpreadOfLeg2Decimal();
	BigDecimal getSpreadOfLeg2Basis();
	PriceNotationEnum getSpreadNotationOfLeg2();
	ISOCurrencyCodeEnum getSpreadCurrencyOfLeg2();

	/*********************** Build Methods  ***********************/
	SpreadOfLeg2 build();
	
	SpreadOfLeg2.SpreadOfLeg2Builder toBuilder();
	
	static SpreadOfLeg2.SpreadOfLeg2Builder builder() {
		return new SpreadOfLeg2.SpreadOfLeg2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SpreadOfLeg2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SpreadOfLeg2> getType() {
		return SpreadOfLeg2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("spreadOfLeg2Monetary"), BigDecimal.class, getSpreadOfLeg2Monetary(), this);
		processor.processBasic(path.newSubPath("spreadOfLeg2Decimal"), BigDecimal.class, getSpreadOfLeg2Decimal(), this);
		processor.processBasic(path.newSubPath("spreadOfLeg2Basis"), BigDecimal.class, getSpreadOfLeg2Basis(), this);
		processor.processBasic(path.newSubPath("spreadNotationOfLeg2"), PriceNotationEnum.class, getSpreadNotationOfLeg2(), this);
		processor.processBasic(path.newSubPath("spreadCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, getSpreadCurrencyOfLeg2(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface SpreadOfLeg2Builder extends SpreadOfLeg2, RosettaModelObjectBuilder {
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Monetary(BigDecimal spreadOfLeg2Monetary);
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Decimal(BigDecimal spreadOfLeg2Decimal);
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Basis(BigDecimal spreadOfLeg2Basis);
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadNotationOfLeg2(PriceNotationEnum spreadNotationOfLeg2);
		SpreadOfLeg2.SpreadOfLeg2Builder setSpreadCurrencyOfLeg2(ISOCurrencyCodeEnum spreadCurrencyOfLeg2);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("spreadOfLeg2Monetary"), BigDecimal.class, getSpreadOfLeg2Monetary(), this);
			processor.processBasic(path.newSubPath("spreadOfLeg2Decimal"), BigDecimal.class, getSpreadOfLeg2Decimal(), this);
			processor.processBasic(path.newSubPath("spreadOfLeg2Basis"), BigDecimal.class, getSpreadOfLeg2Basis(), this);
			processor.processBasic(path.newSubPath("spreadNotationOfLeg2"), PriceNotationEnum.class, getSpreadNotationOfLeg2(), this);
			processor.processBasic(path.newSubPath("spreadCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, getSpreadCurrencyOfLeg2(), this);
		}
		

		SpreadOfLeg2.SpreadOfLeg2Builder prune();
	}

	/*********************** Immutable Implementation of SpreadOfLeg2  ***********************/
	class SpreadOfLeg2Impl implements SpreadOfLeg2 {
		private final BigDecimal spreadOfLeg2Monetary;
		private final BigDecimal spreadOfLeg2Decimal;
		private final BigDecimal spreadOfLeg2Basis;
		private final PriceNotationEnum spreadNotationOfLeg2;
		private final ISOCurrencyCodeEnum spreadCurrencyOfLeg2;
		
		protected SpreadOfLeg2Impl(SpreadOfLeg2.SpreadOfLeg2Builder builder) {
			this.spreadOfLeg2Monetary = builder.getSpreadOfLeg2Monetary();
			this.spreadOfLeg2Decimal = builder.getSpreadOfLeg2Decimal();
			this.spreadOfLeg2Basis = builder.getSpreadOfLeg2Basis();
			this.spreadNotationOfLeg2 = builder.getSpreadNotationOfLeg2();
			this.spreadCurrencyOfLeg2 = builder.getSpreadCurrencyOfLeg2();
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Monetary")
		@RuneAttribute("spreadOfLeg2Monetary")
		public BigDecimal getSpreadOfLeg2Monetary() {
			return spreadOfLeg2Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Decimal")
		@RuneAttribute("spreadOfLeg2Decimal")
		public BigDecimal getSpreadOfLeg2Decimal() {
			return spreadOfLeg2Decimal;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Basis")
		@RuneAttribute("spreadOfLeg2Basis")
		public BigDecimal getSpreadOfLeg2Basis() {
			return spreadOfLeg2Basis;
		}
		
		@Override
		@RosettaAttribute("spreadNotationOfLeg2")
		@RuneAttribute("spreadNotationOfLeg2")
		public PriceNotationEnum getSpreadNotationOfLeg2() {
			return spreadNotationOfLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyOfLeg2")
		@RuneAttribute("spreadCurrencyOfLeg2")
		public ISOCurrencyCodeEnum getSpreadCurrencyOfLeg2() {
			return spreadCurrencyOfLeg2;
		}
		
		@Override
		public SpreadOfLeg2 build() {
			return this;
		}
		
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder toBuilder() {
			SpreadOfLeg2.SpreadOfLeg2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SpreadOfLeg2.SpreadOfLeg2Builder builder) {
			ofNullable(getSpreadOfLeg2Monetary()).ifPresent(builder::setSpreadOfLeg2Monetary);
			ofNullable(getSpreadOfLeg2Decimal()).ifPresent(builder::setSpreadOfLeg2Decimal);
			ofNullable(getSpreadOfLeg2Basis()).ifPresent(builder::setSpreadOfLeg2Basis);
			ofNullable(getSpreadNotationOfLeg2()).ifPresent(builder::setSpreadNotationOfLeg2);
			ofNullable(getSpreadCurrencyOfLeg2()).ifPresent(builder::setSpreadCurrencyOfLeg2);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadOfLeg2 _that = getType().cast(o);
		
			if (!Objects.equals(spreadOfLeg2Monetary, _that.getSpreadOfLeg2Monetary())) return false;
			if (!Objects.equals(spreadOfLeg2Decimal, _that.getSpreadOfLeg2Decimal())) return false;
			if (!Objects.equals(spreadOfLeg2Basis, _that.getSpreadOfLeg2Basis())) return false;
			if (!Objects.equals(spreadNotationOfLeg2, _that.getSpreadNotationOfLeg2())) return false;
			if (!Objects.equals(spreadCurrencyOfLeg2, _that.getSpreadCurrencyOfLeg2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadOfLeg2Monetary != null ? spreadOfLeg2Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Decimal != null ? spreadOfLeg2Decimal.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Basis != null ? spreadOfLeg2Basis.hashCode() : 0);
			_result = 31 * _result + (spreadNotationOfLeg2 != null ? spreadNotationOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyOfLeg2 != null ? spreadCurrencyOfLeg2.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadOfLeg2 {" +
				"spreadOfLeg2Monetary=" + this.spreadOfLeg2Monetary + ", " +
				"spreadOfLeg2Decimal=" + this.spreadOfLeg2Decimal + ", " +
				"spreadOfLeg2Basis=" + this.spreadOfLeg2Basis + ", " +
				"spreadNotationOfLeg2=" + this.spreadNotationOfLeg2 + ", " +
				"spreadCurrencyOfLeg2=" + this.spreadCurrencyOfLeg2 +
			'}';
		}
	}

	/*********************** Builder Implementation of SpreadOfLeg2  ***********************/
	class SpreadOfLeg2BuilderImpl implements SpreadOfLeg2.SpreadOfLeg2Builder {
	
		protected BigDecimal spreadOfLeg2Monetary;
		protected BigDecimal spreadOfLeg2Decimal;
		protected BigDecimal spreadOfLeg2Basis;
		protected PriceNotationEnum spreadNotationOfLeg2;
		protected ISOCurrencyCodeEnum spreadCurrencyOfLeg2;
		
		@Override
		@RosettaAttribute("spreadOfLeg2Monetary")
		@RuneAttribute("spreadOfLeg2Monetary")
		public BigDecimal getSpreadOfLeg2Monetary() {
			return spreadOfLeg2Monetary;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Decimal")
		@RuneAttribute("spreadOfLeg2Decimal")
		public BigDecimal getSpreadOfLeg2Decimal() {
			return spreadOfLeg2Decimal;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2Basis")
		@RuneAttribute("spreadOfLeg2Basis")
		public BigDecimal getSpreadOfLeg2Basis() {
			return spreadOfLeg2Basis;
		}
		
		@Override
		@RosettaAttribute("spreadNotationOfLeg2")
		@RuneAttribute("spreadNotationOfLeg2")
		public PriceNotationEnum getSpreadNotationOfLeg2() {
			return spreadNotationOfLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyOfLeg2")
		@RuneAttribute("spreadCurrencyOfLeg2")
		public ISOCurrencyCodeEnum getSpreadCurrencyOfLeg2() {
			return spreadCurrencyOfLeg2;
		}
		
		@RosettaAttribute("spreadOfLeg2Monetary")
		@RuneAttribute("spreadOfLeg2Monetary")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Monetary(BigDecimal _spreadOfLeg2Monetary) {
			this.spreadOfLeg2Monetary = _spreadOfLeg2Monetary == null ? null : _spreadOfLeg2Monetary;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg2Decimal")
		@RuneAttribute("spreadOfLeg2Decimal")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Decimal(BigDecimal _spreadOfLeg2Decimal) {
			this.spreadOfLeg2Decimal = _spreadOfLeg2Decimal == null ? null : _spreadOfLeg2Decimal;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg2Basis")
		@RuneAttribute("spreadOfLeg2Basis")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadOfLeg2Basis(BigDecimal _spreadOfLeg2Basis) {
			this.spreadOfLeg2Basis = _spreadOfLeg2Basis == null ? null : _spreadOfLeg2Basis;
			return this;
		}
		
		@RosettaAttribute("spreadNotationOfLeg2")
		@RuneAttribute("spreadNotationOfLeg2")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadNotationOfLeg2(PriceNotationEnum _spreadNotationOfLeg2) {
			this.spreadNotationOfLeg2 = _spreadNotationOfLeg2 == null ? null : _spreadNotationOfLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadCurrencyOfLeg2")
		@RuneAttribute("spreadCurrencyOfLeg2")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder setSpreadCurrencyOfLeg2(ISOCurrencyCodeEnum _spreadCurrencyOfLeg2) {
			this.spreadCurrencyOfLeg2 = _spreadCurrencyOfLeg2 == null ? null : _spreadCurrencyOfLeg2;
			return this;
		}
		
		@Override
		public SpreadOfLeg2 build() {
			return new SpreadOfLeg2.SpreadOfLeg2Impl(this);
		}
		
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getSpreadOfLeg2Monetary()!=null) return true;
			if (getSpreadOfLeg2Decimal()!=null) return true;
			if (getSpreadOfLeg2Basis()!=null) return true;
			if (getSpreadNotationOfLeg2()!=null) return true;
			if (getSpreadCurrencyOfLeg2()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SpreadOfLeg2.SpreadOfLeg2Builder o = (SpreadOfLeg2.SpreadOfLeg2Builder) other;
			
			
			merger.mergeBasic(getSpreadOfLeg2Monetary(), o.getSpreadOfLeg2Monetary(), this::setSpreadOfLeg2Monetary);
			merger.mergeBasic(getSpreadOfLeg2Decimal(), o.getSpreadOfLeg2Decimal(), this::setSpreadOfLeg2Decimal);
			merger.mergeBasic(getSpreadOfLeg2Basis(), o.getSpreadOfLeg2Basis(), this::setSpreadOfLeg2Basis);
			merger.mergeBasic(getSpreadNotationOfLeg2(), o.getSpreadNotationOfLeg2(), this::setSpreadNotationOfLeg2);
			merger.mergeBasic(getSpreadCurrencyOfLeg2(), o.getSpreadCurrencyOfLeg2(), this::setSpreadCurrencyOfLeg2);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			SpreadOfLeg2 _that = getType().cast(o);
		
			if (!Objects.equals(spreadOfLeg2Monetary, _that.getSpreadOfLeg2Monetary())) return false;
			if (!Objects.equals(spreadOfLeg2Decimal, _that.getSpreadOfLeg2Decimal())) return false;
			if (!Objects.equals(spreadOfLeg2Basis, _that.getSpreadOfLeg2Basis())) return false;
			if (!Objects.equals(spreadNotationOfLeg2, _that.getSpreadNotationOfLeg2())) return false;
			if (!Objects.equals(spreadCurrencyOfLeg2, _that.getSpreadCurrencyOfLeg2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (spreadOfLeg2Monetary != null ? spreadOfLeg2Monetary.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Decimal != null ? spreadOfLeg2Decimal.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2Basis != null ? spreadOfLeg2Basis.hashCode() : 0);
			_result = 31 * _result + (spreadNotationOfLeg2 != null ? spreadNotationOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyOfLeg2 != null ? spreadCurrencyOfLeg2.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "SpreadOfLeg2Builder {" +
				"spreadOfLeg2Monetary=" + this.spreadOfLeg2Monetary + ", " +
				"spreadOfLeg2Decimal=" + this.spreadOfLeg2Decimal + ", " +
				"spreadOfLeg2Basis=" + this.spreadOfLeg2Basis + ", " +
				"spreadNotationOfLeg2=" + this.spreadNotationOfLeg2 + ", " +
				"spreadCurrencyOfLeg2=" + this.spreadCurrencyOfLeg2 +
			'}';
		}
	}
}
