package drr.regulation.mas.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.mas.rewrite.trade.PriceScheduleReport;
import drr.regulation.mas.rewrite.trade.validation.PriceScheduleReportTypeFormatValidator;
import drr.regulation.mas.rewrite.trade.validation.PriceScheduleReportValidator;
import drr.regulation.mas.rewrite.trade.validation.exists.PriceScheduleReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.53.0
 */
@RosettaMeta(model=PriceScheduleReport.class)
public class PriceScheduleReportMeta implements RosettaMetaData<PriceScheduleReport> {

	@Override
	public List<Validator<? super PriceScheduleReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super PriceScheduleReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super PriceScheduleReport> validator(ValidatorFactory factory) {
		return factory.<PriceScheduleReport>create(PriceScheduleReportValidator.class);
	}

	@Override
	public Validator<? super PriceScheduleReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<PriceScheduleReport>create(PriceScheduleReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super PriceScheduleReport> validator() {
		return new PriceScheduleReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super PriceScheduleReport> typeFormatValidator() {
		return new PriceScheduleReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super PriceScheduleReport, Set<String>> onlyExistsValidator() {
		return new PriceScheduleReportOnlyExistsValidator();
	}
}
