package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0042_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0042_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0042_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0042_01";
	String DEFINITION = "if actionType = ActionTypeEnum -> NEWT to-string and cleared = \"Y\" then clearingTimestamp exists and clearingTimestamp = executionTimestamp else if [ ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and cleared = \"Y\" then clearingTimestamp exists else if [\"N\", \"I\"] any = cleared then clearingMember is absent";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0042_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).and(areEqual(MapperS.of(mASTransactionReport).<String>map("getCleared", _mASTransactionReport -> _mASTransactionReport.getCleared()), MapperS.of("Y"), CardinalityOperator.All)).getOrDefault(false)) {
					return exists(MapperS.of(mASTransactionReport).<ZonedDateTime>map("getClearingTimestamp", _mASTransactionReport -> _mASTransactionReport.getClearingTimestamp())).and(areEqual(MapperS.of(mASTransactionReport).<ZonedDateTime>map("getClearingTimestamp", _mASTransactionReport -> _mASTransactionReport.getClearingTimestamp()), MapperS.of(mASTransactionReport).<ZonedDateTime>map("getExecutionTimestamp", _mASTransactionReport -> _mASTransactionReport.getExecutionTimestamp()), CardinalityOperator.All));
				}
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperS.of(mASTransactionReport).<String>map("getCleared", _mASTransactionReport -> _mASTransactionReport.getCleared()), MapperS.of("Y"), CardinalityOperator.All)).getOrDefault(false)) {
					return exists(MapperS.of(mASTransactionReport).<ZonedDateTime>map("getClearingTimestamp", _mASTransactionReport -> _mASTransactionReport.getClearingTimestamp()));
				}
				if (areEqual(MapperC.<String>of(MapperS.of("N"), MapperS.of("I")), MapperS.of(mASTransactionReport).<String>map("getCleared", _mASTransactionReport -> _mASTransactionReport.getCleared()), CardinalityOperator.Any).getOrDefault(false)) {
					return notExists(MapperS.of(mASTransactionReport).<String>map("getClearingMember", _mASTransactionReport -> _mASTransactionReport.getClearingMember()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0042_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
