package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import iso20022.auth030.mas.Frequency13Code__1;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.53.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0122_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0122_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0122_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0122_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and fixedRatePaymentFrequencyPeriodOfLeg2 exists and [Frequency13Code__1 -> YEAR, Frequency13Code__1 -> MNTH, Frequency13Code__1 -> WEEK, Frequency13Code__1 -> DAIL, Frequency13Code__1 -> QURT, Frequency13Code__1 -> EXPI] any = fixedRatePaymentFrequencyPeriodOfLeg2 then (fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 exists and fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 > 0 and fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 < 1000 and if fixedRatePaymentFrequencyPeriodOfLeg2 = Frequency13Code__1 -> EXPI then fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 = 1 else True) else if fixedRatePaymentFrequencyPeriodOfLeg2 is absent or fixedRatePaymentFrequencyPeriodOfLeg2 = Frequency13Code__1 -> ADHO then fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 is absent";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0122_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).and(exists(MapperS.of(mASTransactionReport).<Frequency13Code__1>map("getFixedRatePaymentFrequencyPeriodOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodOfLeg2()))).and(areEqual(MapperC.<Frequency13Code__1>of(MapperS.of(Frequency13Code__1.YEAR), MapperS.of(Frequency13Code__1.MNTH), MapperS.of(Frequency13Code__1.WEEK), MapperS.of(Frequency13Code__1.DAIL), MapperS.of(Frequency13Code__1.QURT), MapperS.of(Frequency13Code__1.EXPI)), MapperS.of(mASTransactionReport).<Frequency13Code__1>map("getFixedRatePaymentFrequencyPeriodOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodOfLeg2()), CardinalityOperator.Any)).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult;
					if (areEqual(MapperS.of(mASTransactionReport).<Frequency13Code__1>map("getFixedRatePaymentFrequencyPeriodOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodOfLeg2()), MapperS.of(Frequency13Code__1.EXPI), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult = areEqual(MapperS.of(mASTransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()), MapperS.of(1), CardinalityOperator.All);
					} else {
						ifThenElseResult = ComparisonResult.of(MapperS.of(true));
					}
					return exists(MapperS.of(mASTransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2())).and(greaterThan(MapperS.of(mASTransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()), MapperS.of(0), CardinalityOperator.All)).and(lessThan(MapperS.of(mASTransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()), MapperS.of(1000), CardinalityOperator.All)).and(ifThenElseResult);
				}
				if (notExists(MapperS.of(mASTransactionReport).<Frequency13Code__1>map("getFixedRatePaymentFrequencyPeriodOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodOfLeg2())).or(areEqual(MapperS.of(mASTransactionReport).<Frequency13Code__1>map("getFixedRatePaymentFrequencyPeriodOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodOfLeg2()), MapperS.of(Frequency13Code__1.ADHO), CardinalityOperator.All)).getOrDefault(false)) {
					return notExists(MapperS.of(mASTransactionReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2", _mASTransactionReport -> _mASTransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0122_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
