package drr.regulation.mas.rewrite.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.mas.rewrite.trade.BasketConstituentsReport;
import drr.regulation.mas.rewrite.trade.MASNonReportable;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.mas.rewrite.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.mas.rewrite.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.mas.rewrite.trade.NotionalQuantityScheduleLeg2Report;
import drr.regulation.mas.rewrite.trade.OtherPaymentReport;
import drr.regulation.mas.rewrite.trade.PriceAndNotation;
import drr.regulation.mas.rewrite.trade.PriceScheduleReport;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg1;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import drr.regulation.mas.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.mas.rewrite.trade.StrikePriceScheduleReport;
import iso20022.auth030.mas.Frequency13Code__1;
import iso20022.auth030.mas.InterestComputationMethod4Code;
import iso20022.auth030.mas.TradingCapacity7Code;
import iso20022.auth030.mas.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class MASTransactionReportOnlyExistsValidator implements ValidatorWithArg<MASTransactionReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends MASTransactionReport> ValidationResult<MASTransactionReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2IdentifierType", ExistenceChecker.isSet((Boolean) o.getCounterparty2IdentifierType()))
				.put("tradingCapacityOfSpecifiedPerson", ExistenceChecker.isSet((TradingCapacity7Code) o.getTradingCapacityOfSpecifiedPerson()))
				.put("direction", ExistenceChecker.isSet((String) o.getDirection()))
				.put("directionOfLeg1", ExistenceChecker.isSet((String) o.getDirectionOfLeg1()))
				.put("directionOfLeg2", ExistenceChecker.isSet((String) o.getDirectionOfLeg2()))
				.put("reportingSpecifiedPerson", ExistenceChecker.isSet((String) o.getReportingSpecifiedPerson()))
				.put("dataSubmitter", ExistenceChecker.isSet((String) o.getDataSubmitter()))
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("uniqueTransactionIdentifierProprietary", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifierProprietary()))
				.put("uniqueProductIdentifier", ExistenceChecker.isSet((String) o.getUniqueProductIdentifier()))
				.put("priorUTI", ExistenceChecker.isSet((String) o.getPriorUTI()))
				.put("priorUTIProprietary", ExistenceChecker.isSet((String) o.getPriorUTIProprietary()))
				.put("contractType", ExistenceChecker.isSet((String) o.getContractType()))
				.put("assetClass", ExistenceChecker.isSet((String) o.getAssetClass()))
				.put("underlying", ExistenceChecker.isSet((String) o.getUnderlying()))
				.put("underlyingIdentificationType", ExistenceChecker.isSet((String) o.getUnderlyingIdentificationType()))
				.put("underlyingIdOther", ExistenceChecker.isSet((String) o.getUnderlyingIdOther()))
				.put("underlyingIdOtherSource", ExistenceChecker.isSet((String) o.getUnderlyingIdOtherSource()))
				.put("nameOfTheUnderlyingIndex", ExistenceChecker.isSet((String) o.getNameOfTheUnderlyingIndex()))
				.put("fixedRateOfLeg1", ExistenceChecker.isSet((BigDecimal) o.getFixedRateOfLeg1()))
				.put("identifierOfFloatingRateOfLeg1", ExistenceChecker.isSet((String) o.getIdentifierOfFloatingRateOfLeg1()))
				.put("nameOfTheFloatingRateOfLeg1", ExistenceChecker.isSet((String) o.getNameOfTheFloatingRateOfLeg1()))
				.put("spreadOfLeg1", ExistenceChecker.isSet((SpreadOfLeg1) o.getSpreadOfLeg1()))
				.put("fixedRateOfLeg2", ExistenceChecker.isSet((BigDecimal) o.getFixedRateOfLeg2()))
				.put("identifierOfFloatingRateOfLeg2", ExistenceChecker.isSet((String) o.getIdentifierOfFloatingRateOfLeg2()))
				.put("nameOfTheFloatingRateOfLeg2", ExistenceChecker.isSet((String) o.getNameOfTheFloatingRateOfLeg2()))
				.put("spreadOfLeg2", ExistenceChecker.isSet((SpreadOfLeg2) o.getSpreadOfLeg2()))
				.put("optionType", ExistenceChecker.isSet((String) o.getOptionType()))
				.put("optionStyle", ExistenceChecker.isSet((String) o.getOptionStyle()))
				.put("firstExerciseDate", ExistenceChecker.isSet((Date) o.getFirstExerciseDate()))
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.put("expirationDate", ExistenceChecker.isSet((Date) o.getExpirationDate()))
				.put("swapLinkID", ExistenceChecker.isSet((String) o.getSwapLinkID()))
				.put("packageIdentifier", ExistenceChecker.isSet((String) o.getPackageIdentifier()))
				.put("deliveryType", ExistenceChecker.isSet((String) o.getDeliveryType()))
				.put("settlementCurrency1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrency1()))
				.put("settlementCurrency2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrency2()))
				.put("finalContractualSettlementDate", ExistenceChecker.isSet((Date) o.getFinalContractualSettlementDate()))
				.put("cleared", ExistenceChecker.isSet((String) o.getCleared()))
				.put("centralCounterparty", ExistenceChecker.isSet((String) o.getCentralCounterparty()))
				.put("clearingMember", ExistenceChecker.isSet((String) o.getClearingMember()))
				.put("clearingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getClearingTimestamp()))
				.put("platformIdentifier", ExistenceChecker.isSet((String) o.getPlatformIdentifier()))
				.put("bookingLocation", ExistenceChecker.isSet((String) o.getBookingLocation()))
				.put("traderLocation", ExistenceChecker.isSet((String) o.getTraderLocation()))
				.put("confirmed", ExistenceChecker.isSet((String) o.getConfirmed()))
				.put("confirmationTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getConfirmationTimestamp()))
				.put("executionTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getExecutionTimestamp()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("basketConstituents", ExistenceChecker.isSet((List<? extends BasketConstituentsReport>) o.getBasketConstituents()))
				.put("valuationAmount", ExistenceChecker.isSet((BigDecimal) o.getValuationAmount()))
				.put("valuationCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getValuationCurrency()))
				.put("valuationMethod", ExistenceChecker.isSet((ValuationType1Code) o.getValuationMethod()))
				.put("valuationTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getValuationTimestamp()))
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("notionalAmountOfTheContractOrLeg1", ExistenceChecker.isSet((BigDecimal) o.getNotionalAmountOfTheContractOrLeg1()))
				.put("notionalCurrencyOfTheContractOrLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrencyOfTheContractOrLeg1()))
				.put("notionalAmountOfLeg2", ExistenceChecker.isSet((BigDecimal) o.getNotionalAmountOfLeg2()))
				.put("notionalCurrencyOfLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrencyOfLeg2()))
				.put("totalNotionalQuantityOfTheContractOrLeg1", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityOfTheContractOrLeg1()))
				.put("quantityUnitOfMeasureForTheContractOrLeg1", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureForTheContractOrLeg1()))
				.put("notionalQuantityOfTheContractOrLeg1", ExistenceChecker.isSet((BigDecimal) o.getNotionalQuantityOfTheContractOrLeg1()))
				.put("quantityFrequencyOfTheContractOrLeg1", ExistenceChecker.isSet((String) o.getQuantityFrequencyOfTheContractOrLeg1()))
				.put("quantityFrequencyMultiplierOfTheContractOrLeg1", ExistenceChecker.isSet((Integer) o.getQuantityFrequencyMultiplierOfTheContractOrLeg1()))
				.put("totalNotionalQuantityLeg2", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg2()))
				.put("quantityUnitOfMeasureLeg2", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg2()))
				.put("notionalQuantityOfLeg2", ExistenceChecker.isSet((BigDecimal) o.getNotionalQuantityOfLeg2()))
				.put("quantityFrequencyOfLeg2", ExistenceChecker.isSet((String) o.getQuantityFrequencyOfLeg2()))
				.put("quantityFrequencyMultiplierOfLeg2", ExistenceChecker.isSet((Integer) o.getQuantityFrequencyMultiplierOfLeg2()))
				.put("callAmount", ExistenceChecker.isSet((BigDecimal) o.getCallAmount()))
				.put("callCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCallCurrency()))
				.put("putAmount", ExistenceChecker.isSet((BigDecimal) o.getPutAmount()))
				.put("putCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPutCurrency()))
				.put("price", ExistenceChecker.isSet((PriceAndNotation) o.getPrice()))
				.put("priceUnitOfMeasure", ExistenceChecker.isSet((String) o.getPriceUnitOfMeasure()))
				.put("priceSchedule", ExistenceChecker.isSet((List<? extends PriceScheduleReport>) o.getPriceSchedule()))
				.put("strikePrice", ExistenceChecker.isSet((StrikePriceAndNotation) o.getStrikePrice()))
				.put("strikePriceSchedule", ExistenceChecker.isSet((List<? extends StrikePriceScheduleReport>) o.getStrikePriceSchedule()))
				.put("optionPremiumAmount", ExistenceChecker.isSet((BigDecimal) o.getOptionPremiumAmount()))
				.put("optionPremiumCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getOptionPremiumCurrency()))
				.put("exchangeRate", ExistenceChecker.isSet((BigDecimal) o.getExchangeRate()))
				.put("exchangeRateBasis", ExistenceChecker.isSet((String) o.getExchangeRateBasis()))
				.put("fixedRateDayCountConventionOfLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFixedRateDayCountConventionOfLeg1()))
				.put("fixedRateDayCountConventionOfLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFixedRateDayCountConventionOfLeg2()))
				.put("floatingRateDayCountConventionOfLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg1()))
				.put("floatingRateDayCountConventionOfLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg2()))
				.put("floatingRateResetFrequencyPeriodOfLeg1", ExistenceChecker.isSet((String) o.getFloatingRateResetFrequencyPeriodOfLeg1()))
				.put("floatingRateResetFrequencyPeriodMultiplierOfLeg1", ExistenceChecker.isSet((Integer) o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1()))
				.put("floatingRateResetFrequencyPeriodOfLeg2", ExistenceChecker.isSet((String) o.getFloatingRateResetFrequencyPeriodOfLeg2()))
				.put("floatingRateResetFrequencyPeriodMultiplierOfLeg2", ExistenceChecker.isSet((Integer) o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2()))
				.put("fixedRatePaymentFrequencyPeriodOfLeg1", ExistenceChecker.isSet((Frequency13Code__1) o.getFixedRatePaymentFrequencyPeriodOfLeg1()))
				.put("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1", ExistenceChecker.isSet((Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1()))
				.put("fixedRatePaymentFrequencyPeriodOfLeg2", ExistenceChecker.isSet((Frequency13Code__1) o.getFixedRatePaymentFrequencyPeriodOfLeg2()))
				.put("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2", ExistenceChecker.isSet((Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()))
				.put("floatingRatePaymentFrequencyPeriodOfLeg1", ExistenceChecker.isSet((Frequency13Code__1) o.getFloatingRatePaymentFrequencyPeriodOfLeg1()))
				.put("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1", ExistenceChecker.isSet((Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()))
				.put("floatingRatePaymentFrequencyPeriodOfLeg2", ExistenceChecker.isSet((Frequency13Code__1) o.getFloatingRatePaymentFrequencyPeriodOfLeg2()))
				.put("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2", ExistenceChecker.isSet((Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()))
				.put("otherPayment", ExistenceChecker.isSet((List<? extends OtherPaymentReport>) o.getOtherPayment()))
				.put("actionType", ExistenceChecker.isSet((String) o.getActionType()))
				.put("eventType", ExistenceChecker.isSet((String) o.getEventType()))
				.put("eventDate", ExistenceChecker.isSet((ZonedDateTime) o.getEventDate()))
				.put("nonReportable", ExistenceChecker.isSet((MASNonReportable) o.getNonReportable()))
				.put("technicalRecordId", ExistenceChecker.isSet((String) o.getTechnicalRecordId()))
				.put("counterparty2Name", ExistenceChecker.isSet((String) o.getCounterparty2Name()))
				.put("executionAgentOfCounterparty1", ExistenceChecker.isSet((String) o.getExecutionAgentOfCounterparty1()))
				.put("executionAgentOfCounterparty2DTCC", ExistenceChecker.isSet((String) o.getExecutionAgentOfCounterparty2DTCC()))
				.put("notionalAmountScheduleLeg1DTCC", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg1Report>) o.getNotionalAmountScheduleLeg1DTCC()))
				.put("notionalAmountScheduleLeg2DTCC", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg2Report>) o.getNotionalAmountScheduleLeg2DTCC()))
				.put("notionalQuantityScheduleLeg1DTCC", ExistenceChecker.isSet((List<? extends NotionalQuantityScheduleLeg1Report>) o.getNotionalQuantityScheduleLeg1DTCC()))
				.put("notionalQuantityScheduleLeg2DTCC", ExistenceChecker.isSet((List<? extends NotionalQuantityScheduleLeg2Report>) o.getNotionalQuantityScheduleLeg2DTCC()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("MASTransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "MASTransactionReport", path, "");
		}
		return failure("MASTransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "MASTransactionReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
