package drr.regulation.mas.rewrite.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class SpreadOfLeg2OnlyExistsValidator implements ValidatorWithArg<SpreadOfLeg2, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends SpreadOfLeg2> ValidationResult<SpreadOfLeg2> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("spreadOfLeg2Monetary", ExistenceChecker.isSet((BigDecimal) o.getSpreadOfLeg2Monetary()))
				.put("spreadOfLeg2Decimal", ExistenceChecker.isSet((BigDecimal) o.getSpreadOfLeg2Decimal()))
				.put("spreadOfLeg2Basis", ExistenceChecker.isSet((BigDecimal) o.getSpreadOfLeg2Basis()))
				.put("spreadNotationOfLeg2", ExistenceChecker.isSet((PriceNotationEnum) o.getSpreadNotationOfLeg2()))
				.put("spreadCurrencyOfLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSpreadCurrencyOfLeg2()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("SpreadOfLeg2", ValidationResult.ValidationType.ONLY_EXISTS, "SpreadOfLeg2", path, "");
		}
		return failure("SpreadOfLeg2", ValidationResult.ValidationType.ONLY_EXISTS, "SpreadOfLeg2", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
