package drr.regulation.techsprint.g20.mas.reports;

import cdm.event.common.Trade;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FixedFloatLeg1Rule.FixedFloatLeg1RuleDefault.class)
public abstract class FixedFloatLeg1Rule implements ReportFunction<TransactionReportInstruction, InterestRatePayout> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ContractForEventRule contractForEventRule;
	@Inject protected IsFixedFloatRule isFixedFloatRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public InterestRatePayout evaluate(TransactionReportInstruction input) {
		InterestRatePayout.InterestRatePayoutBuilder outputBuilder = doEvaluate(input);
		
		final InterestRatePayout output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(InterestRatePayout.class, output);
		}
		
		return output;
	}

	protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(TransactionReportInstruction input);

	public static class FixedFloatLeg1RuleDefault extends FixedFloatLeg1Rule {
		@Override
		protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(TransactionReportInstruction input) {
			InterestRatePayout.InterestRatePayoutBuilder output = InterestRatePayout.builder();
			return assignOutput(output, input);
		}
		
		protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(contractForEventRule.evaluate(input));
			final MapperS<Trade> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> isFixedFloatRule.evaluate(item.get()));
			final MapperC<InterestRatePayout> thenArg2 = thenArg1
				.mapSingleToList(item -> item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()));
			final MapperC<InterestRatePayout> thenArg3 = thenArg2
				.filterItemNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
			output = toBuilder(MapperS.of(thenArg3.get()).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
