package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.functions.ExtractFixedLeg;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(InterestRatePayoutReceiverRule.InterestRatePayoutReceiverRuleDefault.class)
public abstract class InterestRatePayoutReceiverRule implements ReportFunction<TransactionReportInstruction, Party> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ContractForEventRule contractForEventRule;
	@Inject protected ExtractCounterpartyByRole extractCounterpartyByRole;
	@Inject protected ExtractFixedLeg extractFixedLeg;
	@Inject protected IsFixedFloatRule isFixedFloatRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Party evaluate(TransactionReportInstruction input) {
		Party.PartyBuilder outputBuilder = doEvaluate(input);
		
		final Party output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(Party.class, output);
		}
		
		return output;
	}

	protected abstract Party.PartyBuilder doEvaluate(TransactionReportInstruction input);

	public static class InterestRatePayoutReceiverRuleDefault extends InterestRatePayoutReceiverRule {
		@Override
		protected Party.PartyBuilder doEvaluate(TransactionReportInstruction input) {
			Party.PartyBuilder output = Party.builder();
			return assignOutput(output, input);
		}
		
		protected Party.PartyBuilder assignOutput(Party.PartyBuilder output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(contractForEventRule.evaluate(input));
			final MapperS<Trade> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> isFixedFloatRule.evaluate(item.get()));
			final ReferenceWithMetaParty referenceWithMetaParty = thenArg1
				.mapSingleToItem(item -> MapperS.of(extractCounterpartyByRole.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Counterparty>mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), MapperS.of(extractFixedLeg.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).getMulti())).<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get())).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference())).get();
			if (referenceWithMetaParty == null) {
				output = null;
			} else {
				output = toBuilder(referenceWithMetaParty.getValue());
			}
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
