package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Address;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.techsprint.g20.mas.Trader;
import javax.inject.Inject;


@ImplementedBy(TraderIsInSingaporeRule.TraderIsInSingaporeRuleDefault.class)
public abstract class TraderIsInSingaporeRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAddressInSingaporeRule isAddressInSingaporeRule;
	@Inject protected TraderAddressForUTIRule traderAddressForUTIRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class TraderIsInSingaporeRuleDefault extends TraderIsInSingaporeRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<Trader> thenArg0 = MapperS.of(traderAddressForUTIRule.evaluate(input));
			final MapperS<Address> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<Address>map("getPlaceOfEmployment", trader -> trader.getPlaceOfEmployment()));
			output = thenArg1
				.mapSingleToItem(item -> MapperS.of(isAddressInSingaporeRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
