package drr.regulation.techsprint.g20.mas.validation.exists;

import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.techsprint.g20.mas.MASSFATransactionReport;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class MASSFATransactionReportOnlyExistsValidator implements ValidatorWithArg<MASSFATransactionReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends MASSFATransactionReport> ValidationResult<MASSFATransactionReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("uniqueProductIdentifier", ExistenceChecker.isSet((String) o.getUniqueProductIdentifier()))
				.put("priorUniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getPriorUniqueTransactionIdentifier()))
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("reportingEntity", ExistenceChecker.isSet((String) o.getReportingEntity()))
				.put("cleared", ExistenceChecker.isSet((String) o.getCleared()))
				.put("clearedEntity", ExistenceChecker.isSet((String) o.getClearedEntity()))
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.put("terminationDate", ExistenceChecker.isSet((Date) o.getTerminationDate()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("optionType", ExistenceChecker.isSet((String) o.getOptionType()))
				.put("optionExpirationDate", ExistenceChecker.isSet((String) o.getOptionExpirationDate()))
				.put("optionPremium", ExistenceChecker.isSet((String) o.getOptionPremium()))
				.put("interestRateNotionalAmountLeg1", ExistenceChecker.isSet((BigDecimal) o.getInterestRateNotionalAmountLeg1()))
				.put("interestRateNotionalCurrencyLeg1", ExistenceChecker.isSet((String) o.getInterestRateNotionalCurrencyLeg1()))
				.put("interestRateNotionalAmountLeg2", ExistenceChecker.isSet((BigDecimal) o.getInterestRateNotionalAmountLeg2()))
				.put("interestRateNotionalCurrencyLeg2", ExistenceChecker.isSet((String) o.getInterestRateNotionalCurrencyLeg2()))
				.put("interestRatePayerLeg1", ExistenceChecker.isSet((String) o.getInterestRatePayerLeg1()))
				.put("interestRatePayerLeg2", ExistenceChecker.isSet((String) o.getInterestRatePayerLeg2()))
				.put("interestRateRateLeg1", ExistenceChecker.isSet((BigDecimal) o.getInterestRateRateLeg1()))
				.put("interestRateRateLeg2", ExistenceChecker.isSet((BigDecimal) o.getInterestRateRateLeg2()))
				.put("interestRatePaymentFrequencyPeriodLeg1", ExistenceChecker.isSet((PeriodExtendedEnum) o.getInterestRatePaymentFrequencyPeriodLeg1()))
				.put("interestRatePaymentFrequencyMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getInterestRatePaymentFrequencyMultiplierLeg1()))
				.put("interestRatePaymentFrequencyPeriodLeg2", ExistenceChecker.isSet((PeriodExtendedEnum) o.getInterestRatePaymentFrequencyPeriodLeg2()))
				.put("interestRatePaymentFrequencyMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getInterestRatePaymentFrequencyMultiplierLeg2()))
				.put("interestRateDayCountLeg1", ExistenceChecker.isSet((DayCountFractionEnum) o.getInterestRateDayCountLeg1()))
				.put("interestRateDayCountLeg2", ExistenceChecker.isSet((DayCountFractionEnum) o.getInterestRateDayCountLeg2()))
				.put("interestRateResetFrequencyPeriodLeg1", ExistenceChecker.isSet((PeriodExtendedEnum) o.getInterestRateResetFrequencyPeriodLeg1()))
				.put("interestRateResetFrequencyMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getInterestRateResetFrequencyMultiplierLeg1()))
				.put("interestRateResetFrequencyPeriodLeg2", ExistenceChecker.isSet((PeriodExtendedEnum) o.getInterestRateResetFrequencyPeriodLeg2()))
				.put("interestRateResetFrequencyMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getInterestRateResetFrequencyMultiplierLeg2()))
				.put("interestRatePrice", ExistenceChecker.isSet((BigDecimal) o.getInterestRatePrice()))
				.put("fXCurrency1", ExistenceChecker.isSet((String) o.getFXCurrency1()))
				.put("fXCurrency2", ExistenceChecker.isSet((String) o.getFXCurrency2()))
				.put("fXExchangeRate", ExistenceChecker.isSet((BigDecimal) o.getFXExchangeRate()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("MASSFATransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "MASSFATransactionReport", path, "");
		}
		return failure("MASSFATransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "MASSFATransactionReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
