package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;


@ImplementedBy(CDECurrencyOfExcessCollateralPostedRule.CDECurrencyOfExcessCollateralPostedRuleDefault.class)
public abstract class CDECurrencyOfExcessCollateralPostedRule implements ReportFunction<CollateralReportInstruction, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(CollateralReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(CollateralReportInstruction input);

	public static class CDECurrencyOfExcessCollateralPostedRuleDefault extends CDECurrencyOfExcessCollateralPostedRule {
		@Override
		protected String doEvaluate(CollateralReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, CollateralReportInstruction input) {
			output = "";
			
			return output;
		}
	}
}
