package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.PositionForEvent;
import drr.regulation.common.functions.TradeForEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CDELevelRule.CDELevelRuleDefault.class)
public abstract class CDELevelRule implements ReportFunction<ReportableEvent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected PositionForEvent positionForEvent;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ReportableEvent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ReportableEvent input);

	public static class CDELevelRuleDefault extends CDELevelRule {
		@Override
		protected String doEvaluate(ReportableEvent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ReportableEvent input) {
			if (exists(MapperS.of(tradeForEvent.evaluate(input))).getOrDefault(false)) {
				output = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of("TCTN")).get();
			} else if (exists(MapperS.of(positionForEvent.evaluate(input))).getOrDefault(false)) {
				output = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of("PSTN")).get();
			} else {
				output = null;
			}
			
			return output;
		}
	}
}
