package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(CDENotionalAmountScheduleAmountRule.CDENotionalAmountScheduleAmountRuleDefault.class)
public abstract class CDENotionalAmountScheduleAmountRule implements ReportFunction<QuantityReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(QuantityReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(QuantityReportablePeriod input);

	public static class CDENotionalAmountScheduleAmountRuleDefault extends CDENotionalAmountScheduleAmountRule {
		@Override
		protected BigDecimal doEvaluate(QuantityReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, QuantityReportablePeriod input) {
			final MapperS<BigDecimal> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> item.<BigDecimal>map("getPeriodValue", quantityReportablePeriod -> quantityReportablePeriod.getPeriodValue()));
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
