package drr.standards.iosco.cde.reports;

import cdm.base.math.UnitType;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPriceNotation;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CDESpreadLeg2CurrencyRule.CDESpreadLeg2CurrencyRuleDefault.class)
public abstract class CDESpreadLeg2CurrencyRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg2Rule cDESpreadLeg2Rule;
	@Inject protected GetPriceNotation getPriceNotation;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDESpreadLeg2CurrencyRuleDefault extends CDESpreadLeg2CurrencyRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final PriceSchedule priceSchedule = cDESpreadLeg2Rule.evaluate(input);
			final MapperS<ReferenceWithMetaPriceSchedule> thenArg = priceSchedule == null ? MapperS.<ReferenceWithMetaPriceSchedule>ofNull() : MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build());
			final FieldWithMetaString fieldWithMetaString = thenArg
				.mapSingleToItem(item -> {
					final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = item.get();
					if (areEqual(MapperS.of(getPriceNotation.evaluate((referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()))), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
						return item.<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).<UnitType>map("getUnit", _priceSchedule -> _priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency());
					}
					return MapperS.<FieldWithMetaString>ofNull();
				}).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
