package iso20022.auth030.asic.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.asic.TradeReport33Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("TradeReport33Choice__1Choice")
@ImplementedBy(TradeReport33Choice1Choice.Default.class)
public interface TradeReport33Choice1Choice extends Validator<TradeReport33Choice__1> {
	
	String NAME = "TradeReport33Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<TradeReport33Choice__1> validate(RosettaPath path, TradeReport33Choice__1 tradeReport33Choice__1);
	
	class Default implements TradeReport33Choice1Choice {
	
		@Override
		public ValidationResult<TradeReport33Choice__1> validate(RosettaPath path, TradeReport33Choice__1 tradeReport33Choice__1) {
			ComparisonResult result = executeDataRule(tradeReport33Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "TradeReport33Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "TradeReport33Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(TradeReport33Choice__1 tradeReport33Choice__1) {
			try {
				return choice(MapperS.of(tradeReport33Choice__1), Arrays.asList("new", "mod", "crrctn", "termntn", "valtnUpd", "err", "portOut", "rvv"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements TradeReport33Choice1Choice {
	
		@Override
		public ValidationResult<TradeReport33Choice__1> validate(RosettaPath path, TradeReport33Choice__1 tradeReport33Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "TradeReport33Choice__1", path, DEFINITION);
		}
	}
}
