package iso20022.auth030.esma.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.esma.AssetClassCommodityMetal2Choice;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodityMetal2ChoiceChoice")
@ImplementedBy(AssetClassCommodityMetal2ChoiceChoice.Default.class)
public interface AssetClassCommodityMetal2ChoiceChoice extends Validator<AssetClassCommodityMetal2Choice> {
	
	String NAME = "AssetClassCommodityMetal2ChoiceChoice";
	String DEFINITION = "one-of";
	
	ValidationResult<AssetClassCommodityMetal2Choice> validate(RosettaPath path, AssetClassCommodityMetal2Choice assetClassCommodityMetal2Choice);
	
	class Default implements AssetClassCommodityMetal2ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityMetal2Choice> validate(RosettaPath path, AssetClassCommodityMetal2Choice assetClassCommodityMetal2Choice) {
			ComparisonResult result = executeDataRule(assetClassCommodityMetal2Choice);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityMetal2Choice", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AssetClassCommodityMetal2Choice", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodityMetal2Choice assetClassCommodityMetal2Choice) {
			try {
				return choice(MapperS.of(assetClassCommodityMetal2Choice), Arrays.asList("nonPrcs", "prcs"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodityMetal2ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityMetal2Choice> validate(RosettaPath path, AssetClassCommodityMetal2Choice assetClassCommodityMetal2Choice) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityMetal2Choice", path, DEFINITION);
		}
	}
}
