package iso20022.auth030.fca;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.fca.AssetClassProductType4Code;
import iso20022.auth030.fca.AssetClassSubProductType49Code;
import iso20022.auth030.fca.FreightCommodityOther2__1;
import iso20022.auth030.fca.FreightCommodityOther2__1.FreightCommodityOther2__1Builder;
import iso20022.auth030.fca.FreightCommodityOther2__1.FreightCommodityOther2__1BuilderImpl;
import iso20022.auth030.fca.FreightCommodityOther2__1.FreightCommodityOther2__1Impl;
import iso20022.auth030.fca.meta.FreightCommodityOther2__1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Other freight commodity derivative.
 * @version ${project.version}
 */
@RosettaDataType(value="FreightCommodityOther2__1", builder=FreightCommodityOther2__1.FreightCommodityOther2__1BuilderImpl.class, version="${project.version}")
public interface FreightCommodityOther2__1 extends RosettaModelObject {

	FreightCommodityOther2__1Meta metaData = new FreightCommodityOther2__1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType4Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType49Code getSubPdct();

	/*********************** Build Methods  ***********************/
	FreightCommodityOther2__1 build();
	
	FreightCommodityOther2__1.FreightCommodityOther2__1Builder toBuilder();
	
	static FreightCommodityOther2__1.FreightCommodityOther2__1Builder builder() {
		return new FreightCommodityOther2__1.FreightCommodityOther2__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FreightCommodityOther2__1> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends FreightCommodityOther2__1> getType() {
		return FreightCommodityOther2__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType4Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType49Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface FreightCommodityOther2__1Builder extends FreightCommodityOther2__1, RosettaModelObjectBuilder {
		FreightCommodityOther2__1.FreightCommodityOther2__1Builder setBasePdct(AssetClassProductType4Code basePdct);
		FreightCommodityOther2__1.FreightCommodityOther2__1Builder setSubPdct(AssetClassSubProductType49Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType4Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType49Code.class, getSubPdct(), this);
		}
		

		FreightCommodityOther2__1.FreightCommodityOther2__1Builder prune();
	}

	/*********************** Immutable Implementation of FreightCommodityOther2__1  ***********************/
	class FreightCommodityOther2__1Impl implements FreightCommodityOther2__1 {
		private final AssetClassProductType4Code basePdct;
		private final AssetClassSubProductType49Code subPdct;
		
		protected FreightCommodityOther2__1Impl(FreightCommodityOther2__1.FreightCommodityOther2__1Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType4Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType49Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public FreightCommodityOther2__1 build() {
			return this;
		}
		
		@Override
		public FreightCommodityOther2__1.FreightCommodityOther2__1Builder toBuilder() {
			FreightCommodityOther2__1.FreightCommodityOther2__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FreightCommodityOther2__1.FreightCommodityOther2__1Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FreightCommodityOther2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FreightCommodityOther2__1 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of FreightCommodityOther2__1  ***********************/
	class FreightCommodityOther2__1BuilderImpl implements FreightCommodityOther2__1.FreightCommodityOther2__1Builder {
	
		protected AssetClassProductType4Code basePdct;
		protected AssetClassSubProductType49Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		public AssetClassProductType4Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public AssetClassSubProductType49Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		public FreightCommodityOther2__1.FreightCommodityOther2__1Builder setBasePdct(AssetClassProductType4Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		public FreightCommodityOther2__1.FreightCommodityOther2__1Builder setSubPdct(AssetClassSubProductType49Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public FreightCommodityOther2__1 build() {
			return new FreightCommodityOther2__1.FreightCommodityOther2__1Impl(this);
		}
		
		@Override
		public FreightCommodityOther2__1.FreightCommodityOther2__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FreightCommodityOther2__1.FreightCommodityOther2__1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FreightCommodityOther2__1.FreightCommodityOther2__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FreightCommodityOther2__1.FreightCommodityOther2__1Builder o = (FreightCommodityOther2__1.FreightCommodityOther2__1Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FreightCommodityOther2__1 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FreightCommodityOther2__1Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
