package iso20022.auth030.fca.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.CommonTradeDataReport69__5;
import iso20022.auth030.fca.CounterpartySpecificData36__4;
import iso20022.auth030.fca.ModificationLevel1Code__1;
import iso20022.auth030.fca.TradeData42__5;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class TradeData42__5Validator implements Validator<TradeData42__5> {

	private List<ComparisonResult> getComparisonResults(TradeData42__5 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("ctrPtySpcfcData", (CounterpartySpecificData36__4) o.getCtrPtySpcfcData() != null ? 1 : 0, 1, 1), 
				checkCardinality("cmonTradData", (CommonTradeDataReport69__5) o.getCmonTradData() != null ? 1 : 0, 1, 1), 
				checkCardinality("lvl", (ModificationLevel1Code__1) o.getLvl() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public ValidationResult<TradeData42__5> validate(RosettaPath path, TradeData42__5 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("TradeData42__5", ValidationType.CARDINALITY, "TradeData42__5", path, "", error);
		}
		return success("TradeData42__5", ValidationType.CARDINALITY, "TradeData42__5", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradeData42__5 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("TradeData42__5", ValidationType.CARDINALITY, "TradeData42__5", path, "", res.getError());
				}
				return success("TradeData42__5", ValidationType.CARDINALITY, "TradeData42__5", path, "");
			})
			.collect(toList());
	}

}
