package iso20022.auth030.fca.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.fca.AssetClassCommodityMetal2Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodityMetal2Choice__1Choice")
@ImplementedBy(AssetClassCommodityMetal2Choice1Choice.Default.class)
public interface AssetClassCommodityMetal2Choice1Choice extends Validator<AssetClassCommodityMetal2Choice__1> {
	
	String NAME = "AssetClassCommodityMetal2Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<AssetClassCommodityMetal2Choice__1> validate(RosettaPath path, AssetClassCommodityMetal2Choice__1 assetClassCommodityMetal2Choice__1);
	
	class Default implements AssetClassCommodityMetal2Choice1Choice {
	
		@Override
		public ValidationResult<AssetClassCommodityMetal2Choice__1> validate(RosettaPath path, AssetClassCommodityMetal2Choice__1 assetClassCommodityMetal2Choice__1) {
			ComparisonResult result = executeDataRule(assetClassCommodityMetal2Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityMetal2Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AssetClassCommodityMetal2Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodityMetal2Choice__1 assetClassCommodityMetal2Choice__1) {
			try {
				return choice(MapperS.of(assetClassCommodityMetal2Choice__1), Arrays.asList("nonPrcs", "prcs"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodityMetal2Choice1Choice {
	
		@Override
		public ValidationResult<AssetClassCommodityMetal2Choice__1> validate(RosettaPath path, AssetClassCommodityMetal2Choice__1 assetClassCommodityMetal2Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityMetal2Choice__1", path, DEFINITION);
		}
	}
}
