package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.DerivativeEvent6__5;
import iso20022.auth030.hkma.dtcc.EventIdentifier1Choice__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class DerivativeEvent6__5Validator implements Validator<DerivativeEvent6__5> {

	private List<ComparisonResult> getComparisonResults(DerivativeEvent6__5 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("id", (EventIdentifier1Choice__1) o.getId() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<DerivativeEvent6__5> validate(RosettaPath path, DerivativeEvent6__5 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("DerivativeEvent6__5", ValidationType.CARDINALITY, "DerivativeEvent6__5", path, "", error);
		}
		return success("DerivativeEvent6__5", ValidationType.CARDINALITY, "DerivativeEvent6__5", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, DerivativeEvent6__5 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("DerivativeEvent6__5", ValidationType.CARDINALITY, "DerivativeEvent6__5", path, "", res.getError());
				}
				return success("DerivativeEvent6__5", ValidationType.CARDINALITY, "DerivativeEvent6__5", path, "");
			})
			.collect(toList());
	}

}
