package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.Frequency19Code__1;
import iso20022.auth030.hkma.dtcc.QuantityTerm1__1;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class QuantityTerm1__1Validator implements Validator<QuantityTerm1__1> {

	private List<ComparisonResult> getComparisonResults(QuantityTerm1__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("qty", (BigDecimal) o.getQty() != null ? 1 : 0, 0, 1), 
				checkCardinality("val", (Integer) o.getVal() != null ? 1 : 0, 0, 1), 
				checkCardinality("tmUnit", (Frequency19Code__1) o.getTmUnit() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<QuantityTerm1__1> validate(RosettaPath path, QuantityTerm1__1 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("QuantityTerm1__1", ValidationType.CARDINALITY, "QuantityTerm1__1", path, "", error);
		}
		return success("QuantityTerm1__1", ValidationType.CARDINALITY, "QuantityTerm1__1", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, QuantityTerm1__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("QuantityTerm1__1", ValidationType.CARDINALITY, "QuantityTerm1__1", path, "", res.getError());
				}
				return success("QuantityTerm1__1", ValidationType.CARDINALITY, "QuantityTerm1__1", path, "");
			})
			.collect(toList());
	}

}
