package iso20022.auth030.hkma.dtcc.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.OrganisationIdentification15Choice__4;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("OrganisationIdentification15Choice__4Choice")
@ImplementedBy(OrganisationIdentification15Choice4Choice.Default.class)
public interface OrganisationIdentification15Choice4Choice extends Validator<OrganisationIdentification15Choice__4> {
	
	String NAME = "OrganisationIdentification15Choice__4Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<OrganisationIdentification15Choice__4> validate(RosettaPath path, OrganisationIdentification15Choice__4 organisationIdentification15Choice__4);
	
	class Default implements OrganisationIdentification15Choice4Choice {
	
		@Override
		public ValidationResult<OrganisationIdentification15Choice__4> validate(RosettaPath path, OrganisationIdentification15Choice__4 organisationIdentification15Choice__4) {
			ComparisonResult result = executeDataRule(organisationIdentification15Choice__4);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "OrganisationIdentification15Choice__4", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "OrganisationIdentification15Choice__4", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(OrganisationIdentification15Choice__4 organisationIdentification15Choice__4) {
			try {
				return choice(MapperS.of(organisationIdentification15Choice__4), Arrays.asList("lei", "othr"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements OrganisationIdentification15Choice4Choice {
	
		@Override
		public ValidationResult<OrganisationIdentification15Choice__4> validate(RosettaPath path, OrganisationIdentification15Choice__4 organisationIdentification15Choice__4) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "OrganisationIdentification15Choice__4", path, DEFINITION);
		}
	}
}
