package iso20022.auth030.hkma.tr;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.tr.SupplementaryDataEnvelope1;
import iso20022.auth030.hkma.tr.SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder;
import iso20022.auth030.hkma.tr.SupplementaryDataEnvelope1.SupplementaryDataEnvelope1BuilderImpl;
import iso20022.auth030.hkma.tr.SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Impl;
import iso20022.auth030.hkma.tr.meta.SupplementaryDataEnvelope1Meta;


/**
 * Technical component that contains the validated supplementary data information. This technical envelope allows to segregate the supplementary data information from any other information.
 * @version ${project.version}
 */
@RosettaDataType(value="SupplementaryDataEnvelope1", builder=SupplementaryDataEnvelope1.SupplementaryDataEnvelope1BuilderImpl.class, version="${project.version}")
public interface SupplementaryDataEnvelope1 extends RosettaModelObject {

	SupplementaryDataEnvelope1Meta metaData = new SupplementaryDataEnvelope1Meta();

	/*********************** Getter Methods  ***********************/

	/*********************** Build Methods  ***********************/
	SupplementaryDataEnvelope1 build();
	
	SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder toBuilder();
	
	static SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder builder() {
		return new SupplementaryDataEnvelope1.SupplementaryDataEnvelope1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SupplementaryDataEnvelope1> metaData() {
		return metaData;
	}
	
	@Override
	default Class<? extends SupplementaryDataEnvelope1> getType() {
		return SupplementaryDataEnvelope1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
	}
	

	/*********************** Builder Interface  ***********************/
	interface SupplementaryDataEnvelope1Builder extends SupplementaryDataEnvelope1, RosettaModelObjectBuilder {

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
		}
		

		SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder prune();
	}

	/*********************** Immutable Implementation of SupplementaryDataEnvelope1  ***********************/
	class SupplementaryDataEnvelope1Impl implements SupplementaryDataEnvelope1 {
		
		protected SupplementaryDataEnvelope1Impl(SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder builder) {
		}
		
		@Override
		public SupplementaryDataEnvelope1 build() {
			return this;
		}
		
		@Override
		public SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder toBuilder() {
			SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder builder) {
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
		
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			return _result;
		}
		
		@Override
		public String toString() {
			return "SupplementaryDataEnvelope1 {" +
			'}';
		}
	}

	/*********************** Builder Implementation of SupplementaryDataEnvelope1  ***********************/
	class SupplementaryDataEnvelope1BuilderImpl implements SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder {
	
		
		@Override
		public SupplementaryDataEnvelope1 build() {
			return new SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Impl(this);
		}
		
		@Override
		public SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder o = (SupplementaryDataEnvelope1.SupplementaryDataEnvelope1Builder) other;
			
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
		
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			return _result;
		}
		
		@Override
		public String toString() {
			return "SupplementaryDataEnvelope1Builder {" +
			'}';
		}
	}
}
