package iso20022.auth030.hkma.tr.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.AssetClassProductType9Code;
import iso20022.auth030.hkma.tr.AssetClassSubProductType18Code;
import iso20022.auth030.hkma.tr.PolypropyleneCommodityPlastic2;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class PolypropyleneCommodityPlastic2Validator implements Validator<PolypropyleneCommodityPlastic2> {

	private List<ComparisonResult> getComparisonResults(PolypropyleneCommodityPlastic2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("basePdct", (AssetClassProductType9Code) o.getBasePdct() != null ? 1 : 0, 1, 1), 
				checkCardinality("subPdct", (AssetClassSubProductType18Code) o.getSubPdct() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public ValidationResult<PolypropyleneCommodityPlastic2> validate(RosettaPath path, PolypropyleneCommodityPlastic2 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("PolypropyleneCommodityPlastic2", ValidationType.CARDINALITY, "PolypropyleneCommodityPlastic2", path, "", error);
		}
		return success("PolypropyleneCommodityPlastic2", ValidationType.CARDINALITY, "PolypropyleneCommodityPlastic2", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PolypropyleneCommodityPlastic2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PolypropyleneCommodityPlastic2", ValidationType.CARDINALITY, "PolypropyleneCommodityPlastic2", path, "", res.getError());
				}
				return success("PolypropyleneCommodityPlastic2", ValidationType.CARDINALITY, "PolypropyleneCommodityPlastic2", path, "");
			})
			.collect(toList());
	}

}
