package iso20022.auth030.hkma.tr.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.AssetClassCommodityPaper5Choice;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("AssetClassCommodityPaper5ChoiceChoice")
@ImplementedBy(AssetClassCommodityPaper5ChoiceChoice.Default.class)
public interface AssetClassCommodityPaper5ChoiceChoice extends Validator<AssetClassCommodityPaper5Choice> {
	
	String NAME = "AssetClassCommodityPaper5ChoiceChoice";
	String DEFINITION = "one-of";
	
	ValidationResult<AssetClassCommodityPaper5Choice> validate(RosettaPath path, AssetClassCommodityPaper5Choice assetClassCommodityPaper5Choice);
	
	class Default implements AssetClassCommodityPaper5ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityPaper5Choice> validate(RosettaPath path, AssetClassCommodityPaper5Choice assetClassCommodityPaper5Choice) {
			ComparisonResult result = executeDataRule(assetClassCommodityPaper5Choice);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityPaper5Choice", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AssetClassCommodityPaper5Choice", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(AssetClassCommodityPaper5Choice assetClassCommodityPaper5Choice) {
			try {
				return choice(MapperS.of(assetClassCommodityPaper5Choice), Arrays.asList("cntnrBrd", "nwsprnt", "pulp", "rcvrdPpr", "othr"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AssetClassCommodityPaper5ChoiceChoice {
	
		@Override
		public ValidationResult<AssetClassCommodityPaper5Choice> validate(RosettaPath path, AssetClassCommodityPaper5Choice assetClassCommodityPaper5Choice) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AssetClassCommodityPaper5Choice", path, DEFINITION);
		}
	}
}
