package iso20022.auth030.hkma.tr.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.tr.SecuritiesTransactionPrice23Choice__1;
import java.util.Arrays;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version ${project.version}
 */
@RosettaDataRule("SecuritiesTransactionPrice23Choice__1Choice")
@ImplementedBy(SecuritiesTransactionPrice23Choice1Choice.Default.class)
public interface SecuritiesTransactionPrice23Choice1Choice extends Validator<SecuritiesTransactionPrice23Choice__1> {
	
	String NAME = "SecuritiesTransactionPrice23Choice__1Choice";
	String DEFINITION = "one-of";
	
	ValidationResult<SecuritiesTransactionPrice23Choice__1> validate(RosettaPath path, SecuritiesTransactionPrice23Choice__1 securitiesTransactionPrice23Choice__1);
	
	class Default implements SecuritiesTransactionPrice23Choice1Choice {
	
		@Override
		public ValidationResult<SecuritiesTransactionPrice23Choice__1> validate(RosettaPath path, SecuritiesTransactionPrice23Choice__1 securitiesTransactionPrice23Choice__1) {
			ComparisonResult result = executeDataRule(securitiesTransactionPrice23Choice__1);
			if (result.get()) {
				return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SecuritiesTransactionPrice23Choice__1", path, DEFINITION);
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return ValidationResult.failure(NAME, ValidationType.DATA_RULE, "SecuritiesTransactionPrice23Choice__1", path, DEFINITION, failureMessage);
		}
		
		private ComparisonResult executeDataRule(SecuritiesTransactionPrice23Choice__1 securitiesTransactionPrice23Choice__1) {
			try {
				return choice(MapperS.of(securitiesTransactionPrice23Choice__1), Arrays.asList("mntryVal", "dcml"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SecuritiesTransactionPrice23Choice1Choice {
	
		@Override
		public ValidationResult<SecuritiesTransactionPrice23Choice__1> validate(RosettaPath path, SecuritiesTransactionPrice23Choice__1 securitiesTransactionPrice23Choice__1) {
			return ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SecuritiesTransactionPrice23Choice__1", path, DEFINITION);
		}
	}
}
