package iso20022.auth030.hkma.tr.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.hkma.tr.LegalPersonIdentification1__4;
import iso20022.auth030.hkma.tr.OrganisationIdentification15Choice__5;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class LegalPersonIdentification1__4OnlyExistsValidator implements ValidatorWithArg<LegalPersonIdentification1__4, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends LegalPersonIdentification1__4> ValidationResult<LegalPersonIdentification1__4> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("id", ExistenceChecker.isSet((OrganisationIdentification15Choice__5) o.getId()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("LegalPersonIdentification1__4", ValidationType.ONLY_EXISTS, "LegalPersonIdentification1__4", path, "");
		}
		return failure("LegalPersonIdentification1__4", ValidationType.ONLY_EXISTS, "LegalPersonIdentification1__4", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
