package iso20022.auth108.esma.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth108.esma.DerivativesTradeMarginDataReportV01;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

public class DerivativesTradeMarginDataReportV01TypeFormatValidator implements Validator<DerivativesTradeMarginDataReportV01> {

	private List<ComparisonResult> getComparisonResults(DerivativesTradeMarginDataReportV01 o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public ValidationResult<DerivativesTradeMarginDataReportV01> validate(RosettaPath path, DerivativesTradeMarginDataReportV01 o) {
		String error = getComparisonResults(o)
			.stream()
			.filter(res -> !res.get())
			.map(res -> res.getError())
			.collect(joining("; "));

		if (!isNullOrEmpty(error)) {
			return failure("DerivativesTradeMarginDataReportV01", ValidationType.TYPE_FORMAT, "DerivativesTradeMarginDataReportV01", path, "", error);
		}
		return success("DerivativesTradeMarginDataReportV01", ValidationType.TYPE_FORMAT, "DerivativesTradeMarginDataReportV01", path, "");
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, DerivativesTradeMarginDataReportV01 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("DerivativesTradeMarginDataReportV01", ValidationType.TYPE_FORMAT, "DerivativesTradeMarginDataReportV01", path, "", res.getError());
				}
				return success("DerivativesTradeMarginDataReportV01", ValidationType.TYPE_FORMAT, "DerivativesTradeMarginDataReportV01", path, "");
			})
			.collect(toList());
	}

}
