# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['IndexReferenceInformation']


class IndexReferenceInformation(BaseDataClass):
    """
    A class defining information related to Index
    """
    indexName: Optional[AttributeWithMeta[str] | str] = Field(None, description="The name of the index expressed as a free format string with an associated scheme.")
    """
    The name of the index expressed as a free format string with an associated scheme.
    """
    indexId: List[AttributeWithMeta[str] | str] = Field([], description="An index identifier (e.g. RED pair code).")
    """
    An index identifier (e.g. RED pair code).
    """
    productIdentifier: List[cdm.base.staticdata.asset.common.ProductIdentifier.ProductIdentifier] = Field([], description="Comprises an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the ProductIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.")
    """
    Comprises an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the ProductIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    """
    
    @rosetta_condition
    def condition_0_IndexAttributes(self):
        """
        A required choice condition for either a floating rate or inflation rate index.
        """
        item = self
        return ((rosetta_attr_exists(rosetta_resolve_attr(self, "indexName")) or rosetta_attr_exists(rosetta_resolve_attr(self, "indexId"))) or rosetta_attr_exists(rosetta_resolve_attr(self, "productIdentifier")))

import cdm 
import cdm.base.staticdata.asset.common.ProductIdentifier
