# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['EntityIdentifierTypeEnum']

class EntityIdentifierTypeEnum(Enum):
    """
    The enumeration values associated with legal entity identifier sources.
    """
    BIC = "BIC"
    """
    The Bank Identifier Code.
    """
    COUNTRY_CODE = "CountryCode"
    """
    The ISO 3166 Country Code.
    """
    LEI = "LEI"
    """
    The ISO 17442:2012 Legal Entity Identifier.
    """
    MIC = "MIC"
    """
    The ISO 10383 Market Identifier Code (MIC).
    """
    OTHER = "Other"
    """
    Used when the identifier type is not otherwise in this enumerated list because it is internal or other reasons.  The source can be identified in the scheme which is part of the identifier attribute.
    """
    REDID = "REDID"
    """
    The Reference Entity Database identifier.
    """
