/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.OvernightIndex;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableOvernightIndex
implements OvernightIndex,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final boolean active;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final HolidayCalendarId fixingCalendar;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final int publicationDateOffset;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final int effectiveDateOffset;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount defaultFixedLegDayCount;
    private static final long serialVersionUID = 1L;

    private static void applyDefaults(Builder builder) {
        builder.active = true;
    }

    private static void preBuild(Builder builder) {
        if (builder.defaultFixedLegDayCount == null) {
            builder.defaultFixedLegDayCount = builder.dayCount;
        }
    }

    @Override
    public Tenor getTenor() {
        return Tenor.TENOR_1D;
    }

    @Override
    public FloatingRateName getFloatingRateName() {
        return FloatingRateName.of(this.name);
    }

    @Override
    public LocalDate calculatePublicationFromFixing(LocalDate fixingDate, ReferenceData refData) {
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        return fixingCal.shift(fixingCal.nextOrSame(fixingDate), this.publicationDateOffset);
    }

    @Override
    public LocalDate calculateEffectiveFromFixing(LocalDate fixingDate, ReferenceData refData) {
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        return fixingCal.shift(fixingCal.nextOrSame(fixingDate), this.effectiveDateOffset);
    }

    @Override
    public LocalDate calculateMaturityFromFixing(LocalDate fixingDate, ReferenceData refData) {
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        return fixingCal.shift(fixingCal.nextOrSame(fixingDate), this.effectiveDateOffset + 1);
    }

    @Override
    public LocalDate calculateFixingFromEffective(LocalDate effectiveDate, ReferenceData refData) {
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        return fixingCal.shift(fixingCal.nextOrSame(effectiveDate), -this.effectiveDateOffset);
    }

    @Override
    public LocalDate calculateMaturityFromEffective(LocalDate effectiveDate, ReferenceData refData) {
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        return fixingCal.shift(fixingCal.nextOrSame(effectiveDate), 1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableOvernightIndex) {
            return this.name.equals(((ImmutableOvernightIndex)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableOvernightIndex(String name, Currency currency, boolean active, HolidayCalendarId fixingCalendar, int publicationDateOffset, int effectiveDateOffset, DayCount dayCount, DayCount defaultFixedLegDayCount) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)fixingCalendar, (String)"fixingCalendar");
        JodaBeanUtils.notNull((Object)publicationDateOffset, (String)"publicationDateOffset");
        JodaBeanUtils.notNull((Object)effectiveDateOffset, (String)"effectiveDateOffset");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)defaultFixedLegDayCount, (String)"defaultFixedLegDayCount");
        this.name = name;
        this.currency = currency;
        this.active = active;
        this.fixingCalendar = fixingCalendar;
        this.publicationDateOffset = publicationDateOffset;
        this.effectiveDateOffset = effectiveDateOffset;
        this.dayCount = dayCount;
        this.defaultFixedLegDayCount = defaultFixedLegDayCount;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public HolidayCalendarId getFixingCalendar() {
        return this.fixingCalendar;
    }

    @Override
    public int getPublicationDateOffset() {
        return this.publicationDateOffset;
    }

    @Override
    public int getEffectiveDateOffset() {
        return this.effectiveDateOffset;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    @Override
    public DayCount getDefaultFixedLegDayCount() {
        return this.defaultFixedLegDayCount;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableOvernightIndex> {
        private String name;
        private Currency currency;
        private boolean active;
        private HolidayCalendarId fixingCalendar;
        private int publicationDateOffset;
        private int effectiveDateOffset;
        private DayCount dayCount;
        private DayCount defaultFixedLegDayCount;

        private Builder() {
            ImmutableOvernightIndex.applyDefaults(this);
        }

        private Builder(ImmutableOvernightIndex beanToCopy) {
            this.name = beanToCopy.getName();
            this.currency = beanToCopy.getCurrency();
            this.active = beanToCopy.isActive();
            this.fixingCalendar = beanToCopy.getFixingCalendar();
            this.publicationDateOffset = beanToCopy.getPublicationDateOffset();
            this.effectiveDateOffset = beanToCopy.getEffectiveDateOffset();
            this.dayCount = beanToCopy.getDayCount();
            this.defaultFixedLegDayCount = beanToCopy.getDefaultFixedLegDayCount();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case -1422950650: {
                    return this.active;
                }
                case 394230283: {
                    return this.fixingCalendar;
                }
                case 1901198637: {
                    return this.publicationDateOffset;
                }
                case 1571923688: {
                    return this.effectiveDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -2037801138: {
                    return this.defaultFixedLegDayCount;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -1422950650: {
                    this.active = (Boolean)newValue;
                    break;
                }
                case 394230283: {
                    this.fixingCalendar = (HolidayCalendarId)newValue;
                    break;
                }
                case 1901198637: {
                    this.publicationDateOffset = (Integer)newValue;
                    break;
                }
                case 1571923688: {
                    this.effectiveDateOffset = (Integer)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -2037801138: {
                    this.defaultFixedLegDayCount = (DayCount)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableOvernightIndex build() {
            ImmutableOvernightIndex.preBuild(this);
            return new ImmutableOvernightIndex(this.name, this.currency, this.active, this.fixingCalendar, this.publicationDateOffset, this.effectiveDateOffset, this.dayCount, this.defaultFixedLegDayCount);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder fixingCalendar(HolidayCalendarId fixingCalendar) {
            JodaBeanUtils.notNull((Object)fixingCalendar, (String)"fixingCalendar");
            this.fixingCalendar = fixingCalendar;
            return this;
        }

        public Builder publicationDateOffset(int publicationDateOffset) {
            JodaBeanUtils.notNull((Object)publicationDateOffset, (String)"publicationDateOffset");
            this.publicationDateOffset = publicationDateOffset;
            return this;
        }

        public Builder effectiveDateOffset(int effectiveDateOffset) {
            JodaBeanUtils.notNull((Object)effectiveDateOffset, (String)"effectiveDateOffset");
            this.effectiveDateOffset = effectiveDateOffset;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder defaultFixedLegDayCount(DayCount defaultFixedLegDayCount) {
            JodaBeanUtils.notNull((Object)defaultFixedLegDayCount, (String)"defaultFixedLegDayCount");
            this.defaultFixedLegDayCount = defaultFixedLegDayCount;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("ImmutableOvernightIndex.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("active").append('=').append(JodaBeanUtils.toString((Object)this.active)).append(',').append(' ');
            buf.append("fixingCalendar").append('=').append(JodaBeanUtils.toString((Object)this.fixingCalendar)).append(',').append(' ');
            buf.append("publicationDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.publicationDateOffset)).append(',').append(' ');
            buf.append("effectiveDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.effectiveDateOffset)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("defaultFixedLegDayCount").append('=').append(JodaBeanUtils.toString((Object)this.defaultFixedLegDayCount));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableOvernightIndex.class, String.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ImmutableOvernightIndex.class, Currency.class);
        private final MetaProperty<Boolean> active = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"active", ImmutableOvernightIndex.class, Boolean.TYPE);
        private final MetaProperty<HolidayCalendarId> fixingCalendar = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingCalendar", ImmutableOvernightIndex.class, HolidayCalendarId.class);
        private final MetaProperty<Integer> publicationDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"publicationDateOffset", ImmutableOvernightIndex.class, Integer.TYPE);
        private final MetaProperty<Integer> effectiveDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"effectiveDateOffset", ImmutableOvernightIndex.class, Integer.TYPE);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ImmutableOvernightIndex.class, DayCount.class);
        private final MetaProperty<DayCount> defaultFixedLegDayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"defaultFixedLegDayCount", ImmutableOvernightIndex.class, DayCount.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currency", "active", "fixingCalendar", "publicationDateOffset", "effectiveDateOffset", "dayCount", "defaultFixedLegDayCount"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case -1422950650: {
                    return this.active;
                }
                case 394230283: {
                    return this.fixingCalendar;
                }
                case 1901198637: {
                    return this.publicationDateOffset;
                }
                case 1571923688: {
                    return this.effectiveDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -2037801138: {
                    return this.defaultFixedLegDayCount;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableOvernightIndex> beanType() {
            return ImmutableOvernightIndex.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Boolean> active() {
            return this.active;
        }

        public MetaProperty<HolidayCalendarId> fixingCalendar() {
            return this.fixingCalendar;
        }

        public MetaProperty<Integer> publicationDateOffset() {
            return this.publicationDateOffset;
        }

        public MetaProperty<Integer> effectiveDateOffset() {
            return this.effectiveDateOffset;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<DayCount> defaultFixedLegDayCount() {
            return this.defaultFixedLegDayCount;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableOvernightIndex)bean).getName();
                }
                case 575402001: {
                    return ((ImmutableOvernightIndex)bean).getCurrency();
                }
                case -1422950650: {
                    return ((ImmutableOvernightIndex)bean).isActive();
                }
                case 394230283: {
                    return ((ImmutableOvernightIndex)bean).getFixingCalendar();
                }
                case 1901198637: {
                    return ((ImmutableOvernightIndex)bean).getPublicationDateOffset();
                }
                case 1571923688: {
                    return ((ImmutableOvernightIndex)bean).getEffectiveDateOffset();
                }
                case 1905311443: {
                    return ((ImmutableOvernightIndex)bean).getDayCount();
                }
                case -2037801138: {
                    return ((ImmutableOvernightIndex)bean).getDefaultFixedLegDayCount();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

