/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.light;

import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaProperty;
import org.joda.beans.impl.light.AbstractLightMetaProperty;
import org.joda.beans.impl.light.LightMetaBean;
import org.joda.beans.impl.light.LightMetaProperty;

class LightBeanBuilder<B extends Bean>
implements BeanBuilder<B> {
    private final LightMetaBean<B> metaBean;
    private final Object[] data;

    LightBeanBuilder(LightMetaBean<B> metaBean, Object[] data) {
        this.metaBean = metaBean;
        this.data = data;
    }

    @Override
    public Object get(String propertyName) {
        return this.get(this.metaBean.metaProperty(propertyName));
    }

    @Override
    public <P> P get(MetaProperty<P> metaProperty) {
        return (P)this.data[this.index(metaProperty)];
    }

    @Override
    public BeanBuilder<B> set(String propertyName, Object value) {
        return this.set(this.metaBean.metaProperty(propertyName), value);
    }

    @Override
    public BeanBuilder<B> set(MetaProperty<?> metaProperty, Object value) {
        this.data[this.index(metaProperty)] = value;
        return this;
    }

    private int index(MetaProperty<?> metaProperty) {
        if (metaProperty instanceof LightMetaProperty) {
            int index = ((LightMetaProperty)metaProperty).getConstructorIndex();
            if (index < 0) {
                throw new NoSuchElementException("Derived property cannot be set: " + metaProperty.name());
            }
            return index;
        }
        if (metaProperty instanceof AbstractLightMetaProperty) {
            try {
                int index = ((AbstractLightMetaProperty)metaProperty).getConstructorIndex();
                if (index < 0) {
                    throw new NoSuchElementException("Derived property cannot be set: " + metaProperty.name());
                }
                return index;
            }
            catch (ClassCastException ex) {
                for (MetaProperty<?> mp : this.metaBean.metaPropertyIterable()) {
                    if (!mp.equals(metaProperty)) continue;
                    return ((LightMetaProperty)mp).getConstructorIndex();
                }
                throw new NoSuchElementException("Unknown property: " + metaProperty.name());
            }
        }
        return this.index(this.metaBean.metaProperty(metaProperty.name()));
    }

    @Override
    public B build() {
        return this.metaBean.build(this.data);
    }

    public String toString() {
        return "BeanBuilder for " + this.metaBean.beanName();
    }
}

