/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.object.validators;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.regnosys.rosetta.generator.java.object.validators.AbstractValidatorGenerator;
import com.regnosys.rosetta.generator.java.scoping.JavaClassScope;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.RGeneratedJavaClass;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RCardinality;
import com.regnosys.rosetta.types.RDataType;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.util.types.JavaType;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CardinalityValidatorGenerator
extends AbstractValidatorGenerator {
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;

    @Override
    protected RGeneratedJavaClass<?> createValidatorClass(JavaPojoInterface pojo) {
        return this._javaTypeTranslator.toValidatorClass(pojo);
    }

    @Override
    protected StringConcatenationClient generateClass(final RDataType type, final RGeneratedJavaClass<?> validatorClass, final JavaPojoInterface pojo, String version, final JavaClassScope scope) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public ");
                StringConcatenationClient _asClassDeclaration = validatorClass.asClassDeclaration();
                _builder.append((Object)_asClassDeclaration);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ComparisonResult.class, "\t");
                _builder.append((Object)"> getComparisonResults(");
                _builder.append((Object)pojo, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return ");
                _builder.append(Lists.class, "\t\t");
                _builder.append((Object)".<");
                _builder.append(ComparisonResult.class, "\t\t");
                _builder.append((Object)">newArrayList(");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function = it -> CardinalityValidatorGenerator.this.checkCardinality(pojo, (RAttribute)it, scope);
                Functions.Function1 _function_1 = it -> it != null;
                Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.map(type.getAllAttributes(), (Functions.Function1)_function), (Functions.Function1)_function_1);
                boolean _hasElements = false;
                for (StringConcatenationClient attrCheck : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t\t\t");
                    }
                    _builder.append((Object)"\t\t\t\t");
                    _builder.append((Object)attrCheck, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@Override");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public ");
                _builder.append(List.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ValidationResult.class, "\t");
                _builder.append((Object)"<?>> getValidationResults(");
                _builder.append(RosettaPath.class, "\t");
                _builder.append((Object)" path, ");
                _builder.append((Object)pojo, "\t");
                _builder.append((Object)" o) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return getComparisonResults(o)");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".stream()");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".map(res -> {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"if (!");
                Method _method = CardinalityValidatorGenerator.this._importManagerExtension.method(Strings.class, "isNullOrEmpty");
                _builder.append((Object)_method, "\t\t\t\t");
                _builder.append((Object)"(res.getError())) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t\t");
                _builder.append((Object)"return ");
                Method _method_1 = CardinalityValidatorGenerator.this._importManagerExtension.method(ValidationResult.class, "failure");
                _builder.append((Object)_method_1, "\t\t\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName = pojo.getRosettaName();
                _builder.append((Object)_rosettaName, "\t\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t\t");
                _builder.append((Object)".CARDINALITY, \"");
                String _rosettaName_1 = pojo.getRosettaName();
                _builder.append((Object)_rosettaName_1, "\t\t\t\t\t");
                _builder.append((Object)"\", path, \"\", res.getError());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"return ");
                Method _method_2 = CardinalityValidatorGenerator.this._importManagerExtension.method(ValidationResult.class, "success");
                _builder.append((Object)_method_2, "\t\t\t\t");
                _builder.append((Object)"(\"");
                String _rosettaName_2 = pojo.getRosettaName();
                _builder.append((Object)_rosettaName_2, "\t\t\t\t");
                _builder.append((Object)"\", ");
                _builder.append(ValidationResult.ValidationType.class, "\t\t\t\t");
                _builder.append((Object)".CARDINALITY, \"");
                String _rosettaName_3 = pojo.getRosettaName();
                _builder.append((Object)_rosettaName_3, "\t\t\t\t");
                _builder.append((Object)"\", path, \"\");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"})");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)".collect(");
                Method _method_3 = CardinalityValidatorGenerator.this._importManagerExtension.method(Collectors.class, "toList");
                _builder.append((Object)_method_3, "\t\t\t");
                _builder.append((Object)"());");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _client;
    }

    private StringConcatenationClient checkCardinality(JavaPojoInterface javaType, final RAttribute attr, JavaClassScope scope) {
        StringConcatenationClient _xifexpression = null;
        RCardinality _cardinality = attr.getCardinality();
        boolean _equals = Objects.equals(_cardinality, RCardinality.UNBOUNDED);
        if (_equals) {
            _xifexpression = null;
        } else {
            StringConcatenationClient _client_1;
            StringConcatenationClient _xblockexpression = null;
            final JavaPojoProperty prop = javaType.findProperty(attr.getName());
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"o");
                }
            };
            final JavaExpression propCode = prop.applyGetter(JavaExpression.from(_client, (JavaType)javaType));
            _xifexpression = _xblockexpression = (_client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _isMulti = attr.isMulti();
                    if (_isMulti) {
                        Method _method = CardinalityValidatorGenerator.this._importManagerExtension.method(ExpressionOperatorsNullSafe.class, "checkCardinality");
                        _builder.append((Object)_method);
                        _builder.append((Object)"(\"");
                        String _name = attr.getName();
                        _builder.append((Object)_name);
                        _builder.append((Object)"\", (");
                        JavaType _type = prop.getType();
                        _builder.append((Object)_type);
                        _builder.append((Object)") ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)" == null ? 0 : ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)".size(), ");
                        int _min = attr.getCardinality().getMin();
                        _builder.append((Object)_min);
                        _builder.append((Object)", ");
                        Integer _orElse = attr.getCardinality().getMax().orElse(0);
                        _builder.append((Object)_orElse);
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    } else {
                        Method _method_1 = CardinalityValidatorGenerator.this._importManagerExtension.method(ExpressionOperatorsNullSafe.class, "checkCardinality");
                        _builder.append((Object)_method_1);
                        _builder.append((Object)"(\"");
                        String _name_1 = attr.getName();
                        _builder.append((Object)_name_1);
                        _builder.append((Object)"\", (");
                        JavaType _type_1 = prop.getType();
                        _builder.append((Object)_type_1);
                        _builder.append((Object)") ");
                        _builder.append((Object)propCode);
                        _builder.append((Object)" != null ? 1 : 0, ");
                        int _min_1 = attr.getCardinality().getMin();
                        _builder.append((Object)_min_1);
                        _builder.append((Object)", ");
                        Integer _orElse_1 = attr.getCardinality().getMax().orElse(0);
                        _builder.append((Object)_orElse_1);
                        _builder.append((Object)")");
                        _builder.newLineIfNotEmpty();
                    }
                }
            });
        }
        return _xifexpression;
    }
}

