/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.fasterxml.jackson.core.type.TypeReference;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.scoping.JavaPackageName;
import com.regnosys.rosetta.generator.java.types.JavaConditionInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.types.RGeneratedJavaClass;
import com.regnosys.rosetta.generator.java.types.RJavaEnum;
import com.regnosys.rosetta.generator.java.types.RJavaFieldWithMeta;
import com.regnosys.rosetta.generator.java.types.RJavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.RJavaReferenceWithMeta;
import com.regnosys.rosetta.generator.java.types.RJavaWithMetaValue;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.Operation;
import com.regnosys.rosetta.rosetta.simple.Segment;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RFeature;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.ROperation;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RDateTimeType;
import com.regnosys.rosetta.types.builtin.RDateType;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.types.builtin.RZonedDateTimeType;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.regnosys.rosetta.utils.RosettaTypeSwitch;
import com.rosetta.model.lib.ModelReportId;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.functions.LabelProvider;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.EList;

public class JavaTypeTranslator
extends RosettaTypeSwitch<JavaType, Void> {
    @Inject
    private RosettaJavaPackages packages;
    @Inject
    private RosettaTypeProvider typeProvider;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private JavaTypeUtil typeUtil;
    @Inject
    private ModelIdProvider modelIdProvider;
    @Inject
    private ModelGeneratorUtil generatorUtil;

    @Inject
    public JavaTypeTranslator(RBuiltinTypeService builtins) {
        super(builtins);
    }

    @Deprecated
    public boolean isRosettaModelObject(RAttribute attr) {
        RMetaAnnotatedType rMetaAnnotatedType = attr.getRMetaAnnotatedType();
        return this.isValueRosettaModelObject(attr) || rMetaAnnotatedType.hasAttributeMeta();
    }

    @Deprecated
    public boolean isValueRosettaModelObject(RAttribute attr) {
        RType t = attr.getRMetaAnnotatedType().getRType();
        return t instanceof RDataType || t instanceof RChoiceType;
    }

    public boolean isRosettaModelObject(JavaType type) {
        return this.typeUtil.getItemType(type).isSubtypeOf(this.typeUtil.ROSETTA_MODEL_OBJECT);
    }

    public boolean isValueRosettaModelObject(JavaType type) {
        JavaType itemType = this.typeUtil.getItemType(type);
        if (itemType instanceof RJavaWithMetaValue) {
            return this.isValueRosettaModelObject((RJavaWithMetaValue)itemType);
        }
        return itemType.isSubtypeOf(this.typeUtil.ROSETTA_MODEL_OBJECT);
    }

    public boolean isValueRosettaModelObject(RJavaWithMetaValue t) {
        return t.getValueType().isSubtypeOf(this.typeUtil.ROSETTA_MODEL_OBJECT);
    }

    public JavaParameterizedType<List<?>> toPolymorphicList(JavaReferenceType t) {
        return this.typeUtil.wrapExtends(this.typeUtil.LIST, (JavaType)t);
    }

    public RGeneratedJavaClass<? extends RosettaFunction> toFunctionJavaClass(RFunction func) {
        switch (func.getOrigin()) {
            case FUNCTION: {
                return this.toJavaFunctionClass(func.getSymbolId());
            }
            case REPORT: {
                return this.toJavaReportClass(func.getReportId());
            }
            case RULE: {
                return this.toJavaRuleClass(func.getSymbolId());
            }
        }
        throw new IllegalStateException("Unknown origin of RFunction: " + String.valueOf((Object)func.getOrigin()));
    }

    public RGeneratedJavaClass<? extends RosettaFunction> toFunctionJavaClass(Function func) {
        return this.toJavaFunctionClass(this.modelIdProvider.getSymbolId(func));
    }

    public RGeneratedJavaClass<? extends RosettaFunction> toFunctionJavaClass(RosettaExternalFunction func) {
        return RGeneratedJavaClass.create(JavaPackageName.escape(this.packages.defaultLibFunctions()), func.getName(), RosettaFunction.class);
    }

    public RGeneratedJavaClass<? extends ReportFunction<?, ?>> toReportFunctionJavaClass(RosettaReport report) {
        return this.toJavaReportClass(this.modelIdProvider.getReportId(report));
    }

    private RGeneratedJavaClass<? extends RosettaFunction> toJavaFunctionClass(ModelSymbolId functionId) {
        DottedPath funcPackageName = functionId.getNamespace().child("functions");
        String funcSimpleName = functionId.getName();
        return RGeneratedJavaClass.create(JavaPackageName.escape(funcPackageName), funcSimpleName, RosettaFunction.class);
    }

    private RGeneratedJavaClass<? extends ReportFunction<?, ?>> toJavaReportClass(ModelReportId reportId) {
        DottedPath reportPackageName = reportId.getNamespace().child("reports");
        String reportSimpleName = reportId.joinRegulatoryReference() + "ReportFunction";
        return RGeneratedJavaClass.create(JavaPackageName.escape(reportPackageName), reportSimpleName, new TypeReference<ReportFunction<?, ?>>(){});
    }

    private RGeneratedJavaClass<? extends RosettaFunction> toJavaRuleClass(ModelSymbolId ruleId) {
        DottedPath rulePackageName = ruleId.getNamespace().child("reports");
        String ruleSimpleName = ruleId.getName() + "Rule";
        return RGeneratedJavaClass.create(JavaPackageName.escape(rulePackageName), ruleSimpleName, new TypeReference<ReportFunction<?, ?>>(){});
    }

    public RGeneratedJavaClass<? extends RosettaMetaData<?>> toJavaMetaDataClass(JavaPojoInterface pojoClass) {
        JavaParameterizedType superType = JavaParameterizedType.from(this.typeUtil.ROSETTA_META_DATA, (JavaTypeArgument[])new JavaTypeArgument[]{pojoClass});
        return RGeneratedJavaClass.createImplementingInterface(JavaPackageName.escape(pojoClass.getPackageName().child("meta")), pojoClass.getSimpleName() + "Meta", superType);
    }

    public RGeneratedJavaClass<? extends LabelProvider> toLabelProviderJavaClass(RFunction function) {
        DottedPath packageName = function.getNamespace().child("labels");
        String simpleName = function.getAlphanumericName() + "LabelProvider";
        return RGeneratedJavaClass.create(JavaPackageName.escape(packageName), simpleName, LabelProvider.class);
    }

    public JavaConditionInterface toConditionJavaClass(Condition condition) {
        return JavaConditionInterface.create(condition, this.modelIdProvider, this.typeProvider, this.typeSystem, this.typeUtil, this);
    }

    public JavaClass<?> toDeepPathUtilJavaClass(RDataType choiceType) {
        ModelSymbolId typeId = this.modelIdProvider.getSymbolId(choiceType.getEObject());
        DottedPath packageName = typeId.getNamespace().child("util");
        String simpleName = typeId.getName() + "DeepPathUtil";
        return RGeneratedJavaClass.create(JavaPackageName.escape(packageName), simpleName, Object.class);
    }

    public JavaClass<?> toItemJavaType(RMetaAttribute attr) {
        return this.toJavaReferenceType(attr.getRType());
    }

    public JavaClass<?> toItemJavaType(RAttribute attr) {
        return this.toJavaReferenceType(attr.getRMetaAnnotatedType().getRType());
    }

    public JavaClass<?> toMetaItemJavaType(RAttribute attr) {
        return this.toJavaReferenceType(attr.getRMetaAnnotatedType());
    }

    public JavaClass<?> toForcedMetaItemJavaType(RAttribute attr) {
        JavaClass<?> metaItemJavaType = this.toMetaItemJavaType(attr);
        if (!attr.getRMetaAnnotatedType().hasAttributeMeta()) {
            RType rType = this.typeSystem.stripFromTypeAliases(attr.getRMetaAnnotatedType().getRType());
            DottedPath namespace = this.metaField(rType.getNamespace());
            return new RJavaFieldWithMeta((JavaReferenceType)metaItemJavaType, JavaPackageName.escape(namespace), this.typeUtil);
        }
        return metaItemJavaType;
    }

    public JavaClass<?> toMetaJavaType(RAttribute attr) {
        JavaClass<?> itemType = this.toMetaItemJavaType(attr);
        if (attr.isMulti()) {
            if (this.isRosettaModelObject(attr)) {
                return this.toPolymorphicList((JavaReferenceType)itemType);
            }
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)itemType);
        }
        return itemType;
    }

    public JavaClass<?> toJavaType(RAttribute attr) {
        JavaClass<?> itemType = this.toItemJavaType(attr);
        if (attr.isMulti()) {
            if (this.isRosettaModelObject(attr)) {
                return this.toPolymorphicList((JavaReferenceType)itemType);
            }
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)itemType);
        }
        return itemType;
    }

    public JavaClass<?> toMetaJavaType(RFeature feature) {
        if (feature instanceof RAttribute) {
            return this.toMetaJavaType((RAttribute)feature);
        }
        if (feature instanceof RMetaAttribute) {
            return this.toItemJavaType((RMetaAttribute)feature);
        }
        throw new UnsupportedOperationException("No JavaType exists for feature: " + feature.getName());
    }

    public JavaClass<?> toJavaType(RFeature feature) {
        if (feature instanceof RAttribute) {
            return this.toJavaType((RAttribute)feature);
        }
        if (feature instanceof RMetaAttribute) {
            return this.toItemJavaType((RMetaAttribute)feature);
        }
        throw new UnsupportedOperationException("No JavaType exists for feature: " + feature.getName());
    }

    public JavaClass<?> operationToReferenceWithMetaType(Operation op) {
        RosettaFeature feature;
        if (op.getPath() == null) {
            feature = (RosettaFeature)((Object)op.getAssignRoot());
        } else {
            EList<Segment> segments = op.pathAsSegmentList();
            feature = ((Segment)segments.get(segments.size() - 1)).getFeature();
        }
        return this.toJavaReferenceType(this.typeProvider.getRTypeOfFeature(feature, null));
    }

    public JavaReferenceType operationToMetaJavaType(ROperation op) {
        RFeature feature;
        if (op.getPathTail().isEmpty()) {
            feature = (RFeature)((Object)op.getPathHead());
        } else {
            List<? extends RFeature> segments = op.getPathTail();
            feature = segments.get(segments.size() - 1);
        }
        return this.toMetaJavaType(feature);
    }

    public JavaReferenceType operationToJavaType(ROperation op) {
        RFeature feature;
        if (op.getPathTail().isEmpty()) {
            feature = (RFeature)((Object)op.getPathHead());
        } else {
            List<? extends RFeature> segments = op.getPathTail();
            feature = segments.get(segments.size() - 1);
        }
        return this.toJavaType(feature);
    }

    public JavaClass<?> operationToReferenceWithMetaType(ROperation op) {
        RFeature feature;
        if (op.getPathTail().isEmpty()) {
            feature = (RFeature)((Object)op.getPathHead());
        } else {
            List<? extends RFeature> segments = op.getPathTail();
            feature = segments.get(segments.size() - 1);
        }
        if (feature instanceof RAttribute) {
            return this.toJavaReferenceType(((RAttribute)feature).getRMetaAnnotatedType());
        }
        if (feature instanceof RMetaAttribute) {
            return this.toJavaReferenceType(((RMetaAttribute)feature).getRType());
        }
        throw new UnsupportedOperationException("No JavaReferenceType exists for feature: " + feature.getName());
    }

    private String getTypeDebugInfo(RType type) {
        return type.toString() + " (" + type.getClass().getSimpleName() + ")";
    }

    private String getTypeDebugInfo(RMetaAnnotatedType type) {
        return type.toString() + " (" + type.getClass().getSimpleName() + ")";
    }

    public JavaClass<?> toJavaReferenceType(RMetaAnnotatedType type) {
        JavaType jt = this.toJavaType(type);
        if (jt instanceof JavaPrimitiveType) {
            return ((JavaPrimitiveType)jt).toReferenceType();
        }
        if (jt instanceof JavaClass) {
            return (JavaClass)jt;
        }
        throw new UnsupportedOperationException("Cannot convert type " + this.getTypeDebugInfo(type) + " to a Java reference type.");
    }

    public JavaClass<?> toJavaReferenceType(RType type) {
        JavaType jt = this.toJavaType(type);
        if (jt instanceof JavaPrimitiveType) {
            return ((JavaPrimitiveType)jt).toReferenceType();
        }
        if (jt instanceof JavaClass) {
            return (JavaClass)jt;
        }
        throw new UnsupportedOperationException("Cannot convert type " + this.getTypeDebugInfo(type) + " to a Java reference type.");
    }

    public JavaPojoInterface toJavaReferenceType(RDataType type) {
        return this.toJavaType(type);
    }

    public RJavaEnum toJavaReferenceType(REnumType type) {
        return this.toJavaType(type);
    }

    public JavaClass<?> toJavaReferenceType(Optional<RType> type) {
        if (type.isPresent()) {
            return this.toJavaReferenceType(type.orElseThrow());
        }
        return this.typeUtil.OBJECT;
    }

    public JavaType toJavaType(RMetaAnnotatedType type) {
        JavaClass<?> javaType = this.toJavaReferenceType(type.getRType());
        if (type.hasAttributeMeta()) {
            RType rType = this.typeSystem.stripFromTypeAliases(type.getRType());
            JavaPackageName packageName = JavaPackageName.escape(this.metaField(rType.getNamespace()));
            return this.hasReferenceOrAddressMetadata(type) ? new RJavaReferenceWithMeta((JavaReferenceType)javaType, packageName, this.typeUtil) : new RJavaFieldWithMeta((JavaReferenceType)javaType, packageName, this.typeUtil);
        }
        return javaType;
    }

    private JavaType toJavaType(RType type) {
        return (JavaType)this.doSwitch(type, null);
    }

    public JavaPojoInterface toJavaType(RDataType type) {
        return this.caseDataType(type, null);
    }

    public RJavaEnum toJavaType(REnumType type) {
        return this.caseEnumType(type, null);
    }

    public JavaClass<?> toPolymorphicListOrSingleJavaType(RMetaAnnotatedType type, boolean isMany) {
        if (isMany) {
            return this.toPolymorphicList((JavaReferenceType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaClass<?> toPolymorphicListOrSingleJavaType(RType type, boolean isMany) {
        if (isMany) {
            return this.toPolymorphicList((JavaReferenceType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaClass<?> toListOrSingleJavaType(RMetaAnnotatedType type, boolean isMany) {
        if (isMany) {
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public JavaClass<?> toListOrSingleJavaType(RType type, boolean isMany) {
        if (isMany) {
            return this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)this.toJavaReferenceType(type));
        }
        return this.toJavaReferenceType(type);
    }

    public RGeneratedJavaClass<? extends Validator<?>> toValidatorClass(JavaPojoInterface t) {
        return RGeneratedJavaClass.createImplementingInterface(JavaPackageName.escape(this.validation(t.getPackageName())), t.getSimpleName() + "Validator", JavaParameterizedType.from(this.typeUtil.VALIDATOR, (JavaTypeArgument[])new JavaTypeArgument[]{t}));
    }

    public RGeneratedJavaClass<? extends Validator<?>> toTypeFormatValidatorClass(JavaPojoInterface t) {
        return RGeneratedJavaClass.createImplementingInterface(JavaPackageName.escape(this.validation(t.getPackageName())), t.getSimpleName() + "TypeFormatValidator", JavaParameterizedType.from(this.typeUtil.VALIDATOR, (JavaTypeArgument[])new JavaTypeArgument[]{t}));
    }

    public RGeneratedJavaClass<? extends Validator<?>> toOnlyExistsValidatorClass(JavaPojoInterface t) {
        JavaParameterizedType argType = JavaParameterizedType.from((JavaGenericTypeDeclaration)JavaGenericTypeDeclaration.from((TypeReference)new TypeReference<Set<?>>(){}), (JavaTypeArgument[])new JavaTypeArgument[]{this.typeUtil.STRING});
        return RGeneratedJavaClass.createImplementingInterface(JavaPackageName.escape(this.existsValidation(t.getPackageName())), t.getSimpleName() + "OnlyExistsValidator", JavaParameterizedType.from(this.typeUtil.VALIDATOR_WITH_ARG, (JavaTypeArgument[])new JavaTypeArgument[]{t, argType}));
    }

    private DottedPath metaField(DottedPath p) {
        return p.child("metafields");
    }

    private DottedPath validation(DottedPath p) {
        return p.child("validation");
    }

    public DottedPath existsValidation(DottedPath p) {
        return this.validation(p).child("exists");
    }

    @Override
    protected JavaPojoInterface caseDataType(RDataType type, Void context) {
        return new RJavaPojoInterface(type, this.typeSystem, this, this.typeUtil, this.generatorUtil);
    }

    @Override
    protected JavaPojoInterface caseChoiceType(RChoiceType type, Void context) {
        return this.caseDataType(type.asRDataType(), context);
    }

    @Override
    protected RJavaEnum caseEnumType(REnumType type, Void context) {
        return new RJavaEnum(type);
    }

    @Override
    protected JavaType caseAliasType(RAliasType type, Void context) {
        return this.toJavaType(type.getRefersTo());
    }

    @Override
    protected JavaType caseNumberType(RNumberType type, Void context) {
        if (!type.isInteger()) {
            return JavaClass.from(BigDecimal.class);
        }
        int digits = type.getDigits().orElse(9);
        if (digits <= 9) {
            return JavaPrimitiveType.INT;
        }
        if (digits <= 18) {
            return JavaPrimitiveType.LONG;
        }
        return JavaClass.from(BigInteger.class);
    }

    @Override
    protected JavaClass<String> caseStringType(RStringType type, Void context) {
        return this.typeUtil.STRING;
    }

    @Override
    protected JavaPrimitiveType caseBooleanType(RBasicType type, Void context) {
        return JavaPrimitiveType.BOOLEAN;
    }

    @Override
    protected JavaClass<LocalTime> caseTimeType(RBasicType type, Void context) {
        return this.typeUtil.LOCAL_TIME;
    }

    @Override
    protected JavaClass<Void> caseNothingType(RBasicType type, Void context) {
        return this.typeUtil.VOID;
    }

    @Override
    protected JavaClass<Object> caseAnyType(RBasicType type, Void context) {
        return this.typeUtil.OBJECT;
    }

    @Override
    protected JavaClass<Date> caseDateType(RDateType type, Void context) {
        return this.typeUtil.DATE;
    }

    @Override
    protected JavaClass<LocalDateTime> caseDateTimeType(RDateTimeType type, Void context) {
        return this.typeUtil.LOCAL_DATE_TIME;
    }

    @Override
    protected JavaClass<ZonedDateTime> caseZonedDateTimeType(RZonedDateTimeType type, Void context) {
        return this.typeUtil.ZONED_DATE_TIME;
    }

    private boolean hasReferenceOrAddressMetadata(RMetaAnnotatedType rMetaAnnotatedType) {
        return rMetaAnnotatedType.getMetaAttributes().stream().anyMatch(a -> a.getName().equals("reference") || a.getName().equals("address"));
    }
}

