/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.resource;

import com.regnosys.rosetta.resource.AttributeDescription;
import com.regnosys.rosetta.resource.RosettaModelDescription;
import com.regnosys.rosetta.resource.RuleDescription;
import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

@Singleton
public class RosettaResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    public static final String IN_OVERRIDDEN_NAMESPACE = "IN_OVERRIDDEN_NAMESPACE";
    private static final Logger LOGGER = Logger.getLogger(RosettaResourceDescriptionStrategy.class);

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            return this.doCreateEObjectDescriptions(eObject, this.isInOverriddenNamespace(eObject), acceptor);
        }
        catch (Exception exc) {
            LOGGER.error((Object)exc.getMessage(), (Throwable)exc);
            return true;
        }
    }

    private boolean isInOverriddenNamespace(EObject object) {
        RosettaRootElement elem;
        if (!(object instanceof RosettaRootElement) || (elem = (RosettaRootElement)object).getModel() == null) {
            return false;
        }
        return elem.getModel().isOverridden();
    }

    protected boolean doCreateEObjectDescriptions(EObject eObject, boolean isInOverriddenNamespace, IAcceptor<IEObjectDescription> acceptor) {
        if (eObject instanceof RosettaExpression) {
            return false;
        }
        if (eObject instanceof RosettaModel) {
            RosettaModel model = (RosettaModel)eObject;
            return this.createRosettaModelDescription(model, acceptor);
        }
        if (eObject instanceof Attribute) {
            Attribute attribute = (Attribute)eObject;
            return this.createAttributeDescription(attribute, acceptor);
        }
        if (eObject instanceof RosettaRule) {
            RosettaRule rule = (RosettaRule)eObject;
            return this.createRosettaRuleDescription(rule, acceptor);
        }
        if (eObject instanceof ExternalAnnotationSource) {
            this.defaultCreateEObjectDescriptions(eObject, isInOverriddenNamespace, acceptor);
            return false;
        }
        this.defaultCreateEObjectDescriptions(eObject, isInOverriddenNamespace, acceptor);
        return true;
    }

    private void defaultCreateEObjectDescriptions(EObject eObject, boolean isInOverriddenNamespace, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
        if (qualifiedName != null) {
            acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, isInOverriddenNamespace ? Map.of(IN_OVERRIDDEN_NAMESPACE, "true") : Map.of()));
        }
    }

    private boolean createRosettaModelDescription(RosettaModel model, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)model);
        acceptor.accept((Object)new RosettaModelDescription(qualifiedName, model));
        return true;
    }

    private boolean createAttributeDescription(Attribute attr, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)attr);
        String typeCall = this.serialize(attr.getTypeCall());
        String cardinality = this.serialize(attr.getCard());
        String ruleReferences = this.serialize(attr.getRuleReferences());
        String labels = this.serialize(attr.getLabels());
        acceptor.accept((Object)new AttributeDescription(qualifiedName, attr, typeCall, cardinality, ruleReferences, labels));
        return false;
    }

    private boolean createRosettaRuleDescription(RosettaRule rule, IAcceptor<IEObjectDescription> acceptor) {
        QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName((EObject)rule);
        String input = this.serialize(rule.getInput());
        String expression = this.serialize(rule.getExpression());
        if (qualifiedName != null) {
            acceptor.accept((Object)new RuleDescription(qualifiedName, rule, input, expression));
        }
        return false;
    }

    private String serialize(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)eObject);
        if (node != null) {
            return NodeModelUtils.getTokenText((INode)node);
        }
        return null;
    }

    private String serialize(EList<? extends EObject> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().map(this::serialize).filter(Objects::nonNull).collect(Collectors.joining(","));
    }
}

