/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.google.common.collect.Comparators;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.Import;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class ImportManagementService {
    @Inject
    RosettaEcoreUtil rosettaEcoreUtil;
    @Inject
    IQualifiedNameProvider qualifiedNameProvider;
    private Comparator<Import> importComparator = Comparator.comparing(Import::getImportedNamespace, Comparator.nullsLast(String::compareTo));

    public void cleanupImports(RosettaModel model) {
        EList<Import> imports = model.getImports();
        this.sortImports(imports);
    }

    public List<Import> findUnused(RosettaModel model) {
        ArrayList usedNames = new ArrayList();
        model.eAllContents().forEachRemaining(content -> content.eCrossReferences().stream().filter(ref -> ref instanceof RosettaRootElement).filter(ref -> this.rosettaEcoreUtil.isResolved((RosettaRootElement)ref)).forEach(ref -> {
            QualifiedName fullyQualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)((RosettaRootElement)ref));
            usedNames.add(fullyQualifiedName);
        }));
        ArrayList<Import> unusedImports = new ArrayList<Import>();
        for (Import ns : model.getImports()) {
            boolean isUsed;
            if (ns.getImportedNamespace() == null) continue;
            String[] segments = ns.getImportedNamespace().split("\\.");
            QualifiedName qn = QualifiedName.create((String[])segments);
            boolean isWildcard = "*".equals(qn.getLastSegment());
            if (isWildcard) {
                QualifiedName importNamespace = qn.skipLast(1);
                isUsed = usedNames.stream().anyMatch(name -> {
                    if (name.getSegmentCount() < importNamespace.getSegmentCount()) {
                        return false;
                    }
                    return name.skipLast(name.getSegmentCount() - importNamespace.getSegmentCount()).equals((Object)importNamespace);
                });
            } else {
                isUsed = usedNames.contains(qn);
            }
            if (isUsed) continue;
            unusedImports.add(ns);
        }
        return unusedImports;
    }

    public List<Import> findDuplicates(List<Import> imports) {
        HashSet<String> seenNamespaces = new HashSet<String>();
        ArrayList<Import> duplicates = new ArrayList<Import>();
        for (Import imp : imports) {
            if (seenNamespaces.add(imp.getImportedNamespace())) continue;
            duplicates.add(imp);
        }
        return duplicates;
    }

    public String toString(List<Import> imports) {
        StringBuilder sortedImportsText = new StringBuilder();
        Import previousImport = null;
        for (Import imp : imports) {
            String currentFirstSegment;
            String previousFirstSegment;
            if (previousImport != null && !(previousFirstSegment = previousImport.getImportedNamespace().split("\\.")[0]).equals(currentFirstSegment = imp.getImportedNamespace().split("\\.")[0])) {
                sortedImportsText.append("\n");
            }
            sortedImportsText.append("import ").append(imp.getImportedNamespace());
            if (imp.getNamespaceAlias() != null) {
                sortedImportsText.append(" as ").append(imp.getNamespaceAlias());
            }
            sortedImportsText.append("\n");
            previousImport = imp;
        }
        return sortedImportsText.toString().strip();
    }

    public boolean isSorted(List<Import> imports) {
        return Comparators.isInOrder(imports, this.importComparator);
    }

    public void sortImports(EList<Import> imports) {
        ECollections.sort(imports, this.importComparator);
    }
}

