/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.utils;

import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.rosetta.model.lib.ModelReportId;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.util.DottedPath;

public class ModelIdProvider {
    public DottedPath toDottedPath(RosettaModel namespace) {
        return DottedPath.splitOnDots((String)namespace.getName());
    }

    public <T extends RosettaRootElement & RosettaNamed> ModelSymbolId getSymbolId(T namedRootElement) {
        DottedPath namespace = this.toDottedPath(namedRootElement.getModel());
        String name = ((RosettaNamed)namedRootElement).getName();
        return new ModelSymbolId(namespace, name);
    }

    public ModelReportId getReportId(RosettaReport report) {
        DottedPath namespace = this.toDottedPath(report.getModel());
        String body = report.getRegulatoryBody().getBody().getName();
        String[] corpusList = (String[])report.getRegulatoryBody().getCorpusList().stream().map(c -> c.getName()).toArray(String[]::new);
        return new ModelReportId(namespace, body, corpusList);
    }
}

