/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.common.trade.functions;

import cdm.event.common.TradeState;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.enrichment.common.trade.functions.Create_ReportableEvent;
import drr.regulation.common.ReportableEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=ReportableEventsDefault.class)
public abstract class ReportableEvents
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_ReportableEvent create_ReportableEvent;

    public List<? extends ReportableEvent> evaluate(List<? extends TradeState> eligibleTradeStates, WorkflowStep enrichedWorkflowStep) {
        List reportableEvents;
        List<ReportableEvent.ReportableEventBuilder> reportableEventsBuilder = this.doEvaluate(eligibleTradeStates, enrichedWorkflowStep);
        if (reportableEventsBuilder == null) {
            reportableEvents = null;
        } else {
            reportableEvents = reportableEventsBuilder.stream().map(ReportableEvent::build).collect(Collectors.toList());
            this.objectValidator.validate(ReportableEvent.class, reportableEvents);
        }
        return reportableEvents;
    }

    protected abstract List<ReportableEvent.ReportableEventBuilder> doEvaluate(List<? extends TradeState> var1, WorkflowStep var2);

    public static class ReportableEventsDefault
    extends ReportableEvents {
        @Override
        protected List<ReportableEvent.ReportableEventBuilder> doEvaluate(List<? extends TradeState> eligibleTradeStates, WorkflowStep enrichedWorkflowStep) {
            if (eligibleTradeStates == null) {
                eligibleTradeStates = Collections.emptyList();
            }
            ArrayList<ReportableEvent.ReportableEventBuilder> reportableEvents = new ArrayList<ReportableEvent.ReportableEventBuilder>();
            return this.assignOutput(reportableEvents, eligibleTradeStates, enrichedWorkflowStep);
        }

        protected List<ReportableEvent.ReportableEventBuilder> assignOutput(List<ReportableEvent.ReportableEventBuilder> reportableEvents, List<? extends TradeState> eligibleTradeStates, WorkflowStep enrichedWorkflowStep) {
            reportableEvents.addAll(this.toBuilder(MapperC.of(eligibleTradeStates).mapItem(item -> MapperS.of((Object)this.create_ReportableEvent.evaluate((TradeState)item.get(), enrichedWorkflowStep))).getMulti()));
            return Optional.ofNullable(reportableEvents).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

