/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.eic.functions;

import com.google.common.base.Stopwatch;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import drr.enrichment.eic.functions.GetAcceptedEicCodes;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAcceptedEicCodesImpl
extends GetAcceptedEicCodes {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetAcceptedEicCodesImpl.class);
    public static final String ACCEPTED_EIC_CODES_PATH = "accepted-eic-codes-path";
    public static final String ACCEPTED_EIC_CODES_CSV = "regulatory-reporting/lookup/List-of-Accepted-EICs-2024-07-05.csv";
    private final Set<String> acceptedEicCodesCsv = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String resourceName;

    @Inject
    public GetAcceptedEicCodesImpl(@Named(value="accepted-eic-codes-path") String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    protected List<String> doEvaluate() {
        if (this.acceptedEicCodesCsv.isEmpty()) {
            this.acceptedEicCodesCsv.addAll(this.loadAcceptedEicCodes(this.resourceName));
        }
        return new ArrayList<String>(this.acceptedEicCodesCsv);
    }

    private List<String> loadAcceptedEicCodes(String resourceName) {
        Stopwatch t = Stopwatch.createStarted();
        List paths = ClassPathUtils.loadFromClasspath((String)resourceName, (ClassLoader)this.getClass().getClassLoader()).collect(Collectors.toList());
        if (paths.isEmpty()) {
            LOGGER.warn("Failed to find Accepted EIC codes CSV path for resource: {}, took {}", (Object)resourceName, (Object)t);
            return Collections.emptyList();
        }
        LOGGER.info("Found {} Accepted EIC codes CSV paths for resource: {}: paths: {}, took {}", new Object[]{paths.size(), resourceName, paths, t});
        Path acceptedEicCodesPath = (Path)paths.get(0);
        LOGGER.debug("Accepted EIC codes CSV path: {}", (Object)acceptedEicCodesPath);
        try {
            List<String> acceptedEicCodesCsv = Files.readAllLines(acceptedEicCodesPath, StandardCharsets.UTF_8);
            LOGGER.info("Loaded {} Accepted EIC codes from path {}, took {}", new Object[]{acceptedEicCodesCsv.size(), acceptedEicCodesPath, t});
            return acceptedEicCodesCsv;
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while reading Accepted EIC codes CSV path {} found from resource {}, took {}", new Object[]{acceptedEicCodesPath, resourceName, t, e});
            throw new UncheckedIOException(e);
        }
    }
}

