/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.lei.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.regnosys.drr.utils.gleif.GleifLeiAdaptor;
import com.regnosys.drr.utils.gleif.GleifLeiClient;
import drr.enrichment.lei.LeiData;
import drr.enrichment.lei.functions.API_GetLeiData;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class API_GetLeiDataImpl
extends API_GetLeiData {
    private static final Logger LOGGER = LoggerFactory.getLogger(API_GetLeiDataImpl.class);
    private final GleifLeiClient gleifLeiClient;
    private final GleifLeiAdaptor gleifLeiAdaptor;
    @VisibleForTesting
    protected final Cache<String, Optional<LeiData>> leiDataCache = CacheBuilder.newBuilder().maximumSize(500L).build();

    public API_GetLeiDataImpl(HttpClient httpClient) {
        this(new GleifLeiClient(httpClient), new GleifLeiAdaptor());
    }

    public API_GetLeiDataImpl() {
        this(new GleifLeiClient(), new GleifLeiAdaptor());
    }

    public API_GetLeiDataImpl(GleifLeiClient gleifLeiClient, GleifLeiAdaptor gleifLeiAdaptor) {
        this.gleifLeiClient = gleifLeiClient;
        this.gleifLeiAdaptor = gleifLeiAdaptor;
    }

    public API_GetLeiDataImpl(Map<String, String> preloadLeiData) {
        this();
        this.preloadCache(preloadLeiData);
    }

    private void preloadCache(Map<String, String> preloadLeiData) {
        preloadLeiData.forEach((lei, value) -> {
            Optional leiData = Optional.ofNullable(value).flatMap(jsonResponse -> Optional.ofNullable(this.gleifLeiAdaptor.adapt((String)jsonResponse)));
            this.leiDataCache.put(lei, leiData);
        });
    }

    public Optional<LeiData> getResultForLei(String lei) {
        GleifLeiClient.GleifLeiResult leiDataFromGleif = this.gleifLeiClient.getLeiDataFromGleif(lei);
        return leiDataFromGleif.getData().map(this.gleifLeiAdaptor::adapt);
    }

    @Override
    protected LeiData.LeiDataBuilder doEvaluate(String lei) {
        return Optional.ofNullable(lei).filter(this.gleifLeiClient::isValidLei).flatMap(x -> {
            try {
                Optional leiData = this.leiDataCache.asMap().containsKey(x) ? (Optional)this.leiDataCache.getIfPresent(x) : (Optional)this.leiDataCache.get(x, () -> this.getResultForLei((String)x));
                if (leiData.isEmpty()) {
                    LOGGER.debug("LEI data not found for {}", (Object)lei);
                }
                return leiData;
            }
            catch (ExecutionException e) {
                LOGGER.error("LEI record cache exception", (Throwable)e);
                return Optional.empty();
            }
        }).map(LeiData::toBuilder).orElse(null);
    }
}

