/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.upi.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.upi.UpiData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="UpiDataCardinalityVerification")
@ImplementedBy(value=Default.class)
public interface UpiDataCardinalityVerification
extends Validator<UpiData> {
    public static final String NAME = "UpiDataCardinalityVerification";
    public static final String DEFINITION = "if upiValidation is absent or upiValidation = True then upiOfUnderlying exists and upiRecord exists";

    public static class NoOp
    implements UpiDataCardinalityVerification {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, UpiData upiData) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements UpiDataCardinalityVerification {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, UpiData upiData) {
            ComparisonResult result = this.executeDataRule(upiData);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)UpiDataCardinalityVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"UpiData", (RosettaPath)path, (String)UpiDataCardinalityVerification.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)UpiDataCardinalityVerification.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"UpiData", (RosettaPath)path, (String)UpiDataCardinalityVerification.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(UpiData upiData) {
            try {
                if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)upiData).map("getUpiValidation", _upiData -> _upiData.getUpiValidation())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)upiData).map("getUpiValidation", _upiData -> _upiData.getUpiValidation()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)upiData).map("getUpiOfUnderlying", _upiData -> _upiData.getUpiOfUnderlying())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)upiData).map("getUpiRecord", _upiData -> _upiData.getUpiRecord())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

