/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.fca.AmountAndDirection106__1;
import iso20022.auth030.fca.PriceData2__1;
import iso20022.auth030.fca.Schedule1__1;
import iso20022.auth030.fca.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetTxPricDefault.class)
public abstract class GetTxPric
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public PriceData2__1 evaluate(FCAUKEMIRTransactionReport drrReport) {
        PriceData2__1 txPric;
        PriceData2__1.PriceData2__1Builder txPricBuilder = this.doEvaluate(drrReport);
        if (txPricBuilder == null) {
            txPric = null;
        } else {
            txPric = txPricBuilder.build();
            this.objectValidator.validate(PriceData2__1.class, (RosettaModelObject)txPric);
        }
        return txPric;
    }

    protected abstract PriceData2__1.PriceData2__1Builder doEvaluate(FCAUKEMIRTransactionReport var1);

    public static class GetTxPricDefault
    extends GetTxPric {
        @Override
        protected PriceData2__1.PriceData2__1Builder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
            PriceData2__1.PriceData2__1Builder txPric = PriceData2__1.builder();
            return this.assignOutput(txPric, drrReport);
        }

        protected PriceData2__1.PriceData2__1Builder assignOutput(PriceData2__1.PriceData2__1Builder txPric, FCAUKEMIRTransactionReport drrReport) {
            txPric.setPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).map("getPrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPrice()).mapSingleToItem(item -> {
                AmountAndDirection106__1 ifThenElseResult1 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    Boolean ifThenElseResult0 = null;
                    if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getPriceMonetary", priceAndNotation -> priceAndNotation.getPriceMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = false;
                    }
                    ifThenElseResult1 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPriceMonetary", priceAndNotation -> priceAndNotation.getPriceMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getPrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPrice()).map("getPriceCurrency", priceAndNotation -> priceAndNotation.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult0).build();
                }
                BigDecimal ifThenElseResult2 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult2 = (BigDecimal)item.map("getPricePercentage", priceAndNotation -> priceAndNotation.getPricePercentage()).get();
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(ifThenElseResult1).setPctg(ifThenElseResult2).build());
            }).get());
            txPric.addSchdlPrd(MapperS.of((Object)drrReport).mapC("getPriceSchedule", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPriceSchedule()).mapItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getPriceMonetary", priceScheduleReport -> priceScheduleReport.getPriceMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)Schedule1__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", priceScheduleReport -> priceScheduleReport.getEffectiveDate()).get()).setUadjstdEndDt((Date)item.map("getEndDate", priceScheduleReport -> priceScheduleReport.getEndDate()).get()).setPric(SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPriceMonetary", priceScheduleReport -> priceScheduleReport.getPriceMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getPrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPrice()).map("getPriceCurrency", priceAndNotation -> priceAndNotation.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).setPctg((BigDecimal)item.map("getPricePercentage", priceScheduleReport -> priceScheduleReport.getPricePercentage()).get()).build()).build());
            }).getMulti());
            return Optional.ofNullable(txPric).map(o -> o.prune()).orElse(null);
        }
    }
}

