/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

@ImplementedBy(value=LowerBarrierPriceNotationRuleDefault.class)
public abstract class LowerBarrierPriceNotationRule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected IsOption isOption;
    @Inject
    protected ProductForEvent productForEvent;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class LowerBarrierPriceNotationRuleDefault
    extends LowerBarrierPriceNotationRule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            output = (PriceNotationEnum)((Object)thenArg.mapSingleToItem(item -> {
                Boolean _boolean = this.isOption.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()));
                if (_boolean != null && _boolean.booleanValue()) {
                    if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getFeature", optionPayout -> optionPayout.getFeature()).map("getKnock", optionFeature -> optionFeature.getKnock()).map("getKnockIn", knock -> knock.getKnockIn())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getFeature", optionPayout -> optionPayout.getFeature()).map("getKnock", optionFeature -> optionFeature.getKnock()).map("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getFeature", optionPayout -> optionPayout.getFeature()).map("getKnock", optionFeature -> optionFeature.getKnock()).map("getKnockIn", knock -> knock.getKnockIn()).map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).map("getLevel", trigger -> trigger.getLevel())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getFeature", optionPayout -> optionPayout.getFeature()).map("getKnock", optionFeature -> optionFeature.getKnock()).map("getKnockOut", knock -> knock.getKnockOut()).map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).map("getLevel", trigger -> trigger.getLevel()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)((Object)PriceNotationEnum.MONETARY));
                        }
                        if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getFeature", optionPayout -> optionPayout.getFeature()).map("getKnock", optionFeature -> optionFeature.getKnock()).map("getKnockIn", knock -> knock.getKnockIn()).map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).map("getLevelPercentage", trigger -> trigger.getLevelPercentage())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getFeature", optionPayout -> optionPayout.getFeature()).map("getKnock", optionFeature -> optionFeature.getKnock()).map("getKnockOut", knock -> knock.getKnockOut()).map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).map("getLevelPercentage", trigger -> trigger.getLevelPercentage()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL));
                        }
                        return MapperS.ofNull();
                    }
                    return MapperS.ofNull();
                }
                return MapperS.ofNull();
            }).get());
            return output;
        }
    }
}

